/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.IamPolicy;
import com.google.cloud.Identity;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class IamPolicyTest {
    private static final Identity ALL_USERS = Identity.allUsers();
    private static final Identity ALL_AUTH_USERS = Identity.allAuthenticatedUsers();
    private static final Identity USER = Identity.user((String)"abc@gmail.com");
    private static final Identity SERVICE_ACCOUNT = Identity.serviceAccount((String)"service-account@gmail.com");
    private static final Identity GROUP = Identity.group((String)"group@gmail.com");
    private static final Identity DOMAIN = Identity.domain((String)"google.com");
    private static final Map<String, ImmutableSet<Identity>> BINDINGS = ImmutableMap.of((Object)"viewer", (Object)ImmutableSet.of((Object)USER, (Object)SERVICE_ACCOUNT, (Object)ALL_USERS), (Object)"editor", (Object)ImmutableSet.of((Object)ALL_AUTH_USERS, (Object)GROUP, (Object)DOMAIN));
    private static final PolicyImpl SIMPLE_POLICY = ((PolicyImpl.Builder)((PolicyImpl.Builder)PolicyImpl.builder().addIdentity("viewer", USER, new Identity[]{SERVICE_ACCOUNT, ALL_USERS})).addIdentity("editor", ALL_AUTH_USERS, new Identity[]{GROUP, DOMAIN})).build();
    private static final PolicyImpl FULL_POLICY = new PolicyImpl.Builder(SIMPLE_POLICY.bindings(), "etag", 1).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals(BINDINGS, (Object)FULL_POLICY.bindings());
        Assert.assertEquals((Object)"etag", (Object)FULL_POLICY.etag());
        Assert.assertEquals((long)1L, (long)FULL_POLICY.version().intValue());
        ImmutableMap editorBinding = ImmutableMap.builder().put((Object)"editor", BINDINGS.get("editor")).build();
        PolicyImpl policy = ((PolicyImpl.Builder)FULL_POLICY.toBuilder().bindings((Map)editorBinding)).build();
        Assert.assertEquals((Object)editorBinding, (Object)policy.bindings());
        Assert.assertEquals((Object)"etag", (Object)policy.etag());
        Assert.assertEquals((long)1L, (long)policy.version().intValue());
        policy = ((PolicyImpl.Builder)SIMPLE_POLICY.toBuilder().removeRole("editor")).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"viewer", BINDINGS.get("viewer")), (Object)policy.bindings());
        Assert.assertNull((Object)policy.etag());
        Assert.assertNull((Object)policy.version());
        policy = ((PolicyImpl.Builder)((PolicyImpl.Builder)policy.toBuilder().removeIdentity("viewer", USER, new Identity[]{ALL_USERS})).addIdentity("viewer", DOMAIN, new Identity[]{GROUP})).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"viewer", (Object)ImmutableSet.of((Object)SERVICE_ACCOUNT, (Object)DOMAIN, (Object)GROUP)), (Object)policy.bindings());
        Assert.assertNull((Object)policy.etag());
        Assert.assertNull((Object)policy.version());
        policy = ((PolicyImpl.Builder)((PolicyImpl.Builder)((PolicyImpl.Builder)((PolicyImpl.Builder)PolicyImpl.builder().removeIdentity("viewer", USER, new Identity[0])).addIdentity("owner", USER, new Identity[]{SERVICE_ACCOUNT})).addIdentity("editor", GROUP, new Identity[0])).removeIdentity("editor", GROUP, new Identity[0])).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"owner", (Object)ImmutableSet.of((Object)USER, (Object)SERVICE_ACCOUNT)), (Object)policy.bindings());
        Assert.assertNull((Object)policy.etag());
        Assert.assertNull((Object)policy.version());
    }

    @Test
    public void testIllegalPolicies() {
        HashMap bindings;
        try {
            PolicyImpl.builder().addIdentity(null, USER, new Identity[0]);
            Assert.fail((String)"Null role should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The role cannot be null.", (Object)ex.getMessage());
        }
        try {
            PolicyImpl.builder().addIdentity("viewer", null, new Identity[]{USER});
            Assert.fail((String)"Null identity should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"Null identities are not permitted.", (Object)ex.getMessage());
        }
        try {
            PolicyImpl.builder().addIdentity("viewer", USER, null);
            Assert.fail((String)"Null identity should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"Null identities are not permitted.", (Object)ex.getMessage());
        }
        try {
            PolicyImpl.builder().bindings(null);
            Assert.fail((String)"Null bindings map should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The provided map of bindings cannot be null.", (Object)ex.getMessage());
        }
        try {
            bindings = new HashMap();
            bindings.put("viewer", null);
            PolicyImpl.builder().bindings(bindings);
            Assert.fail((String)"Null set of identities should cause exception.");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"A role cannot be assigned to a null set of identities.", (Object)ex.getMessage());
        }
        try {
            bindings = new HashMap();
            HashSet<Object> identities = new HashSet<Object>();
            identities.add(null);
            bindings.put("viewer", identities);
            PolicyImpl.builder().bindings(bindings);
            Assert.fail((String)"Null identity should cause exception.");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Null identities are not permitted.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testEqualsHashCode() {
        Assert.assertNotNull((Object)((Object)FULL_POLICY));
        PolicyImpl emptyPolicy = PolicyImpl.builder().build();
        AnotherPolicyImpl anotherPolicy = new AnotherPolicyImpl.Builder().build();
        Assert.assertNotEquals((Object)((Object)emptyPolicy), (Object)((Object)anotherPolicy));
        Assert.assertNotEquals((long)emptyPolicy.hashCode(), (long)anotherPolicy.hashCode());
        Assert.assertNotEquals((Object)((Object)FULL_POLICY), (Object)((Object)SIMPLE_POLICY));
        Assert.assertNotEquals((long)FULL_POLICY.hashCode(), (long)SIMPLE_POLICY.hashCode());
        PolicyImpl copy = SIMPLE_POLICY.toBuilder().build();
        Assert.assertEquals((Object)((Object)SIMPLE_POLICY), (Object)((Object)copy));
        Assert.assertEquals((long)SIMPLE_POLICY.hashCode(), (long)copy.hashCode());
    }

    @Test
    public void testBindings() {
        Assert.assertTrue((boolean)PolicyImpl.builder().build().bindings().isEmpty());
        Assert.assertEquals(BINDINGS, (Object)SIMPLE_POLICY.bindings());
    }

    @Test
    public void testEtag() {
        Assert.assertNull((Object)SIMPLE_POLICY.etag());
        Assert.assertEquals((Object)"etag", (Object)FULL_POLICY.etag());
    }

    @Test
    public void testVersion() {
        Assert.assertNull((Object)SIMPLE_POLICY.version());
        Assert.assertEquals((long)1L, (long)FULL_POLICY.version().intValue());
    }

    static class AnotherPolicyImpl
    extends IamPolicy<String> {
        AnotherPolicyImpl(Builder builder) {
            super((IamPolicy.Builder)builder);
        }

        public Builder toBuilder() {
            return new Builder();
        }

        static class Builder
        extends IamPolicy.Builder<String, Builder> {
            private Builder() {
            }

            public AnotherPolicyImpl build() {
                return new AnotherPolicyImpl(this);
            }
        }
    }

    static class PolicyImpl
    extends IamPolicy<String> {
        PolicyImpl(Builder builder) {
            super((IamPolicy.Builder)builder);
        }

        public Builder toBuilder() {
            return new Builder(this.bindings(), this.etag(), this.version());
        }

        static Builder builder() {
            return new Builder();
        }

        static class Builder
        extends IamPolicy.Builder<String, Builder> {
            private Builder() {
            }

            private Builder(Map<String, Set<Identity>> bindings, String etag, Integer version) {
                ((Builder)((Builder)this.bindings(bindings)).etag(etag)).version(version);
            }

            public PolicyImpl build() {
                return new PolicyImpl(this);
            }
        }
    }
}

