/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Identity;
import org.junit.Assert;
import org.junit.Test;

public class IdentityTest {
    private static final Identity ALL_USERS = Identity.allUsers();
    private static final Identity ALL_AUTH_USERS = Identity.allAuthenticatedUsers();
    private static final Identity USER = Identity.user((String)"abc@gmail.com");
    private static final Identity SERVICE_ACCOUNT = Identity.serviceAccount((String)"service-account@gmail.com");
    private static final Identity GROUP = Identity.group((String)"group@gmail.com");
    private static final Identity DOMAIN = Identity.domain((String)"google.com");

    @Test
    public void testAllUsers() {
        Assert.assertEquals((Object)Identity.Type.ALL_USERS, (Object)ALL_USERS.type());
        Assert.assertNull((Object)ALL_USERS.value());
    }

    @Test
    public void testAllAuthenticatedUsers() {
        Assert.assertEquals((Object)Identity.Type.ALL_AUTHENTICATED_USERS, (Object)ALL_AUTH_USERS.type());
        Assert.assertNull((Object)ALL_AUTH_USERS.value());
    }

    @Test
    public void testUser() {
        Assert.assertEquals((Object)Identity.Type.USER, (Object)USER.type());
        Assert.assertEquals((Object)"abc@gmail.com", (Object)USER.value());
    }

    @Test(expected=NullPointerException.class)
    public void testUserNullEmail() {
        Identity.user(null);
    }

    @Test
    public void testServiceAccount() {
        Assert.assertEquals((Object)Identity.Type.SERVICE_ACCOUNT, (Object)SERVICE_ACCOUNT.type());
        Assert.assertEquals((Object)"service-account@gmail.com", (Object)SERVICE_ACCOUNT.value());
    }

    @Test(expected=NullPointerException.class)
    public void testServiceAccountNullEmail() {
        Identity.serviceAccount(null);
    }

    @Test
    public void testGroup() {
        Assert.assertEquals((Object)Identity.Type.GROUP, (Object)GROUP.type());
        Assert.assertEquals((Object)"group@gmail.com", (Object)GROUP.value());
    }

    @Test(expected=NullPointerException.class)
    public void testGroupNullEmail() {
        Identity.group(null);
    }

    @Test
    public void testDomain() {
        Assert.assertEquals((Object)Identity.Type.DOMAIN, (Object)DOMAIN.type());
        Assert.assertEquals((Object)"google.com", (Object)DOMAIN.value());
    }

    @Test(expected=NullPointerException.class)
    public void testDomainNullId() {
        Identity.domain(null);
    }

    @Test
    public void testIdentityToAndFromPb() {
        this.compareIdentities(ALL_USERS, Identity.valueOf((String)ALL_USERS.strValue()));
        this.compareIdentities(ALL_AUTH_USERS, Identity.valueOf((String)ALL_AUTH_USERS.strValue()));
        this.compareIdentities(USER, Identity.valueOf((String)USER.strValue()));
        this.compareIdentities(SERVICE_ACCOUNT, Identity.valueOf((String)SERVICE_ACCOUNT.strValue()));
        this.compareIdentities(GROUP, Identity.valueOf((String)GROUP.strValue()));
        this.compareIdentities(DOMAIN, Identity.valueOf((String)DOMAIN.strValue()));
    }

    private void compareIdentities(Identity expected, Identity actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.type(), (Object)actual.type());
        Assert.assertEquals((Object)expected.value(), (Object)actual.value());
    }
}

