/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.LabelDescriptor;
import com.google.cloud.MonitoredResourceDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MonitoredResourceDescriptorTest {
    private static final MonitoredResourceDescriptor.LabelDescriptor BOOLEAN_LABEL = new MonitoredResourceDescriptor.LabelDescriptor("booleanKey", MonitoredResourceDescriptor.LabelDescriptor.ValueType.BOOL, "Boolean label");
    private static final MonitoredResourceDescriptor.LabelDescriptor STRING_LABEL = new MonitoredResourceDescriptor.LabelDescriptor("stringKey", MonitoredResourceDescriptor.LabelDescriptor.ValueType.STRING, "String label");
    private static final MonitoredResourceDescriptor.LabelDescriptor INT_LABEL = new MonitoredResourceDescriptor.LabelDescriptor("intKey", MonitoredResourceDescriptor.LabelDescriptor.ValueType.INT64, "Int label");
    private static final MonitoredResourceDescriptor.LabelDescriptor INT_LABEL_NO_DESCRIPTION = new MonitoredResourceDescriptor.LabelDescriptor("intKey", MonitoredResourceDescriptor.LabelDescriptor.ValueType.INT64, null);
    private static final String TYPE = "resource_type";
    private static final String NAME = "resourceName";
    private static final String DISPLAY_NAME = "Display Name";
    private static final String DESCRIPTION = "Resource Descriptor";
    private static final List<MonitoredResourceDescriptor.LabelDescriptor> LABELS = ImmutableList.of((Object)BOOLEAN_LABEL, (Object)STRING_LABEL, (Object)INT_LABEL);
    private static final MonitoredResourceDescriptor RESOURCE_DESCRIPTOR = MonitoredResourceDescriptor.builder((String)"resource_type").name("resourceName").displayName("Display Name").description("Resource Descriptor").labels(LABELS).build();

    @Test
    public void testLabelDescriptor() {
        Assert.assertEquals((Object)"booleanKey", (Object)BOOLEAN_LABEL.key());
        Assert.assertEquals((Object)MonitoredResourceDescriptor.LabelDescriptor.ValueType.BOOL, (Object)BOOLEAN_LABEL.valueType());
        Assert.assertEquals((Object)"Boolean label", (Object)BOOLEAN_LABEL.description());
        Assert.assertEquals((Object)"stringKey", (Object)STRING_LABEL.key());
        Assert.assertEquals((Object)MonitoredResourceDescriptor.LabelDescriptor.ValueType.STRING, (Object)STRING_LABEL.valueType());
        Assert.assertEquals((Object)"String label", (Object)STRING_LABEL.description());
        Assert.assertEquals((Object)"intKey", (Object)INT_LABEL.key());
        Assert.assertEquals((Object)MonitoredResourceDescriptor.LabelDescriptor.ValueType.INT64, (Object)INT_LABEL.valueType());
        Assert.assertEquals((Object)"Int label", (Object)INT_LABEL.description());
        Assert.assertEquals((Object)"intKey", (Object)INT_LABEL_NO_DESCRIPTION.key());
        Assert.assertEquals((Object)MonitoredResourceDescriptor.LabelDescriptor.ValueType.INT64, (Object)INT_LABEL_NO_DESCRIPTION.valueType());
        Assert.assertNull((Object)INT_LABEL_NO_DESCRIPTION.description());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TYPE, (Object)RESOURCE_DESCRIPTOR.type());
        Assert.assertEquals((Object)NAME, (Object)RESOURCE_DESCRIPTOR.name());
        Assert.assertEquals((Object)DISPLAY_NAME, (Object)RESOURCE_DESCRIPTOR.displayName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)RESOURCE_DESCRIPTOR.description());
        Assert.assertEquals(LABELS, (Object)RESOURCE_DESCRIPTOR.labels());
        MonitoredResourceDescriptor resourceDescriptor = MonitoredResourceDescriptor.builder((String)TYPE).build();
        Assert.assertEquals((Object)TYPE, (Object)resourceDescriptor.type());
        Assert.assertNull((Object)resourceDescriptor.name());
        Assert.assertNull((Object)resourceDescriptor.displayName());
        Assert.assertNull((Object)resourceDescriptor.description());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)resourceDescriptor.labels());
    }

    @Test
    public void testToAndFromPbLabelDescriptor() {
        this.compareLabelDescriptor(BOOLEAN_LABEL, MonitoredResourceDescriptor.LabelDescriptor.fromPb((LabelDescriptor)BOOLEAN_LABEL.toPb()));
        this.compareLabelDescriptor(STRING_LABEL, MonitoredResourceDescriptor.LabelDescriptor.fromPb((LabelDescriptor)STRING_LABEL.toPb()));
        this.compareLabelDescriptor(INT_LABEL, MonitoredResourceDescriptor.LabelDescriptor.fromPb((LabelDescriptor)INT_LABEL.toPb()));
        this.compareLabelDescriptor(INT_LABEL_NO_DESCRIPTION, MonitoredResourceDescriptor.LabelDescriptor.fromPb((LabelDescriptor)INT_LABEL_NO_DESCRIPTION.toPb()));
    }

    @Test
    public void testToAndFromPb() {
        this.compareResourceDescriptor(RESOURCE_DESCRIPTOR, MonitoredResourceDescriptor.fromPb((com.google.api.MonitoredResourceDescriptor)RESOURCE_DESCRIPTOR.toPb()));
        MonitoredResourceDescriptor resourceDescriptor = MonitoredResourceDescriptor.builder((String)TYPE).build();
        this.compareResourceDescriptor(resourceDescriptor, MonitoredResourceDescriptor.fromPb((com.google.api.MonitoredResourceDescriptor)resourceDescriptor.toPb()));
    }

    private void compareLabelDescriptor(MonitoredResourceDescriptor.LabelDescriptor expected, MonitoredResourceDescriptor.LabelDescriptor value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.key(), (Object)value.key());
        Assert.assertEquals((Object)expected.valueType(), (Object)value.valueType());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }

    private void compareResourceDescriptor(MonitoredResourceDescriptor expected, MonitoredResourceDescriptor value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.displayName(), (Object)value.displayName());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.labels(), (Object)value.labels());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }
}

