/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.MonitoredResource;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class MonitoredResourceTest {
    private static final String TYPE = "cloudsql_database";
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"dataset-id", (Object)"myDataset", (Object)"zone", (Object)"myZone");
    private static final MonitoredResource MONITORED_RESOURCE = MonitoredResource.builder((String)"cloudsql_database").labels(LABELS).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TYPE, (Object)MONITORED_RESOURCE.type());
        Assert.assertEquals(LABELS, (Object)MONITORED_RESOURCE.labels());
        MonitoredResource monitoredResource = MonitoredResource.builder((String)TYPE).addLabel("dataset-id", "myDataset").addLabel("zone", "myZone").build();
        Assert.assertEquals((Object)TYPE, (Object)monitoredResource.type());
        Assert.assertEquals(LABELS, (Object)monitoredResource.labels());
        this.compareMonitoredResource(MONITORED_RESOURCE, monitoredResource);
        monitoredResource = MonitoredResource.builder((String)TYPE).type("global").addLabel("dataset-id", "myDataset").addLabel("zone", "myZone").clearLabels().build();
        Assert.assertEquals((Object)"global", (Object)monitoredResource.type());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)monitoredResource.labels());
    }

    @Test
    public void testToBuilder() {
        this.compareMonitoredResource(MONITORED_RESOURCE, MONITORED_RESOURCE.toBuilder().build());
        MonitoredResource monitoredResource = MONITORED_RESOURCE.toBuilder().type("global").clearLabels().build();
        Assert.assertEquals((Object)"global", (Object)monitoredResource.type());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)monitoredResource.labels());
        monitoredResource = monitoredResource.toBuilder().type(TYPE).labels((Map)ImmutableMap.of((Object)"dataset-id", (Object)"myDataset")).addLabel("zone", "myZone").build();
        this.compareMonitoredResource(MONITORED_RESOURCE, monitoredResource);
    }

    @Test
    public void testOf() {
        MonitoredResource monitoredResource = MonitoredResource.of((String)TYPE, LABELS);
        Assert.assertEquals((Object)TYPE, (Object)monitoredResource.type());
        Assert.assertEquals(LABELS, (Object)monitoredResource.labels());
        this.compareMonitoredResource(MONITORED_RESOURCE, monitoredResource);
    }

    @Test
    public void testToAndFromPb() {
        this.compareMonitoredResource(MONITORED_RESOURCE, MonitoredResource.fromPb((com.google.api.MonitoredResource)MONITORED_RESOURCE.toPb()));
        MonitoredResource monitoredResource = MonitoredResource.of((String)TYPE, (Map)ImmutableMap.of());
        this.compareMonitoredResource(monitoredResource, MonitoredResource.fromPb((com.google.api.MonitoredResource)monitoredResource.toPb()));
    }

    private void compareMonitoredResource(MonitoredResource expected, MonitoredResource value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.labels(), (Object)value.labels());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

