/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.PageImpl;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class PageImplTest {
    private static final ImmutableList<String> VALUES = ImmutableList.of((Object)"1", (Object)"2");
    private static final ImmutableList<String> NEXT_VALUES = ImmutableList.of((Object)"3", (Object)"4");
    private static final ImmutableList<String> ALL_VALUES = ImmutableList.builder().addAll(VALUES).addAll(NEXT_VALUES).build();

    @Test
    public void testPage() {
        final PageImpl nextResult = new PageImpl(null, "c", NEXT_VALUES);
        PageImpl.NextPageFetcher<String> fetcher = new PageImpl.NextPageFetcher<String>(){
            private static final long serialVersionUID = -1714571149183431798L;

            public PageImpl<String> nextPage() {
                return nextResult;
            }
        };
        PageImpl result = new PageImpl((PageImpl.NextPageFetcher)fetcher, "c", VALUES);
        Assert.assertEquals((Object)nextResult, (Object)result.nextPage());
        Assert.assertEquals((Object)"c", (Object)result.nextPageCursor());
        Assert.assertEquals(VALUES, (Object)result.values());
    }

    @Test
    public void testIterateAll() {
        final PageImpl nextResult = new PageImpl(null, "c", NEXT_VALUES);
        PageImpl.NextPageFetcher<String> fetcher = new PageImpl.NextPageFetcher<String>(){

            public PageImpl<String> nextPage() {
                return nextResult;
            }
        };
        PageImpl result = new PageImpl((PageImpl.NextPageFetcher)fetcher, "c", VALUES);
        Assert.assertEquals(ALL_VALUES, (Object)ImmutableList.copyOf((Iterator)result.iterateAll()));
    }
}

