/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Clock;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryParams;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;

public class RetryHelperTest {
    @Test
    public void testTriesWithExceptionHandling() {
        Assert.assertNull((Object)RetryHelper.getContext());
        RetryParams params = RetryParams.builder().initialRetryDelayMillis(0L).retryMaxAttempts(3).build();
        ExceptionHandler handler = ExceptionHandler.builder().retryOn(new Class[]{IOException.class}).abortOn(new Class[]{RuntimeException.class}).build();
        final AtomicInteger count = new AtomicInteger(3);
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() throws IOException, NullPointerException {
                    if (count.decrementAndGet() == 2) {
                        Assert.assertEquals((long)1L, (long)RetryHelper.getContext().getAttemptNumber());
                        throw new IOException("should be retried");
                    }
                    Assert.assertEquals((long)2L, (long)RetryHelper.getContext().getAttemptNumber());
                    throw new NullPointerException("Boo!");
                }
            }, (RetryParams)params, (ExceptionHandler)handler);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (RetryHelper.NonRetriableException ex) {
            Assert.assertEquals((Object)"Boo!", (Object)ex.getCause().getMessage());
            Assert.assertEquals((long)1L, (long)count.intValue());
        }
        Assert.assertNull((Object)RetryHelper.getContext());
        params = RetryParams.builder().initialRetryDelayMillis(0L).retryMaxAttempts(5).build();
        handler = ExceptionHandler.builder().retryOn(new Class[]{E1Exception.class, E4Exception.class}).abortOn(new Class[]{E3Exception.class}).build();
        final Iterator<E1Exception> exceptions = Arrays.asList(new E1Exception(), new E2Exception(), new E4Exception(), new E3Exception()).iterator();
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() throws E1Exception {
                    throw (E1Exception)exceptions.next();
                }
            }, (RetryParams)params, (ExceptionHandler)handler);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (RetryHelper.NonRetriableException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof E3Exception));
        }
        Assert.assertNull((Object)RetryHelper.getContext());
    }

    @Test
    public void testTriesAtLeastMinTimes() {
        RetryParams params = RetryParams.builder().initialRetryDelayMillis(0L).totalRetryPeriodMillis(60000L).retryMinAttempts(5).retryMaxAttempts(10).build();
        int timesToFail = 7;
        Assert.assertNull((Object)RetryHelper.getContext());
        int attempted = (Integer)RetryHelper.runWithRetries((Callable)new Callable<Integer>(){
            int timesCalled;

            @Override
            public Integer call() throws IOException {
                ++this.timesCalled;
                Assert.assertEquals((long)this.timesCalled, (long)RetryHelper.getContext().getAttemptNumber());
                Assert.assertEquals((long)10L, (long)RetryHelper.getContext().getRetryParams().retryMaxAttempts());
                if (this.timesCalled <= 7) {
                    throw new IOException();
                }
                return this.timesCalled;
            }
        }, (RetryParams)params, (ExceptionHandler)ExceptionHandler.defaultInstance());
        Assert.assertEquals((long)8L, (long)attempted);
        Assert.assertNull((Object)RetryHelper.getContext());
    }

    @Test
    public void testTriesNoMoreThanMaxTimes() {
        int maxAttempts = 10;
        RetryParams params = RetryParams.builder().initialRetryDelayMillis(0L).totalRetryPeriodMillis(60000L).retryMinAttempts(0).retryMaxAttempts(10).build();
        final AtomicInteger timesCalled = new AtomicInteger(0);
        try {
            RetryHelper.runWithRetries(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    if (timesCalled.incrementAndGet() <= 10) {
                        throw new RuntimeException();
                    }
                    Assert.fail((String)("Body was executed too many times: " + timesCalled.get()));
                }
            }), (RetryParams)params, (ExceptionHandler)ExceptionHandler.builder().retryOn(new Class[]{RuntimeException.class}).build());
            Assert.fail((String)"Should not have succeeded, expected all attempts to fail and give up.");
        }
        catch (RetryHelper.RetriesExhaustedException expected) {
            Assert.assertEquals((long)10L, (long)timesCalled.get());
        }
    }

    @Test
    public void testTriesNoMoreLongerThanTotalRetryPeriod() {
        final FakeClock fakeClock = new FakeClock();
        RetryParams params = RetryParams.builder().initialRetryDelayMillis(0L).totalRetryPeriodMillis(999L).retryMinAttempts(5).retryMaxAttempts(10).build();
        ExceptionHandler handler = ExceptionHandler.builder().retryOn(new Class[]{RuntimeException.class}).build();
        int sleepOnAttempt = 8;
        final AtomicInteger timesCalled = new AtomicInteger(0);
        try {
            RetryHelper.runWithRetries(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    timesCalled.incrementAndGet();
                    if (timesCalled.get() == 8) {
                        fakeClock.advance(1000L, TimeUnit.MILLISECONDS);
                    }
                    throw new RuntimeException();
                }
            }), (RetryParams)params, (ExceptionHandler)handler, (Clock)fakeClock);
            Assert.fail();
        }
        catch (RetryHelper.RetriesExhaustedException expected) {
            Assert.assertEquals((long)8L, (long)timesCalled.get());
        }
    }

    @Test
    public void testBackoffIsExponential() {
        RetryParams params = RetryParams.builder().initialRetryDelayMillis(10L).maxRetryDelayMillis(10000000L).retryDelayBackoffFactor(2.0).totalRetryPeriodMillis(60000L).retryMinAttempts(0).retryMaxAttempts(100).build();
        long sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)1);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 13L && sleepDuration >= 7L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)2);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 25L && sleepDuration >= 15L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)3);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 50L && sleepDuration >= 30L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)4);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 100L && sleepDuration >= 60L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)5);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 200L && sleepDuration >= 120L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)6);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 400L && sleepDuration >= 240L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)7);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 800L && sleepDuration >= 480L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)8);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 1600L && sleepDuration >= 960L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)9);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 3200L && sleepDuration >= 1920L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)10);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 6400L && sleepDuration >= 3840L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)11);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 12800L && sleepDuration >= 7680L ? 1 : 0) != 0);
        sleepDuration = RetryHelper.getSleepDuration((RetryParams)params, (int)12);
        Assert.assertTrue((String)String.valueOf(sleepDuration), (sleepDuration < 25600L && sleepDuration >= 15360L ? 1 : 0) != 0);
    }

    @Test
    public void testNestedUsage() {
        Assert.assertEquals((long)8L, (long)this.invokeNested(3, 2));
    }

    private int invokeNested(final int level, final int retries) {
        if (level < 0) {
            return 0;
        }
        return (Integer)RetryHelper.runWithRetries((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws IOException {
                if (RetryHelper.getContext().getAttemptNumber() < retries) {
                    throw new IOException();
                }
                Assert.assertEquals((long)retries, (long)RetryHelper.getContext().getAttemptNumber());
                return RetryHelperTest.this.invokeNested(level - 1, retries) + RetryHelper.getContext().getAttemptNumber();
            }
        });
    }

    private static class FakeClock
    extends Clock {
        private final AtomicLong millis = new AtomicLong();

        private FakeClock() {
        }

        void advance(long time, TimeUnit timeUnit) {
            this.millis.addAndGet(timeUnit.toMillis(time));
        }

        public long millis() {
            return this.millis.get();
        }
    }

    static class E4Exception
    extends E2Exception {
        private static final long serialVersionUID = -5508018234693709156L;

        E4Exception() {
        }
    }

    static class E3Exception
    extends E1Exception {
        private static final long serialVersionUID = -7794256022024001666L;

        E3Exception() {
        }
    }

    static class E2Exception
    extends E1Exception {
        private static final long serialVersionUID = -8710227162480133598L;

        E2Exception() {
        }
    }

    static class E1Exception
    extends Exception {
        private static final long serialVersionUID = 3874933713392137001L;

        E1Exception() {
        }
    }
}

