/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.RetryParams;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryParamsTest {
    @Test
    public void testDefaults() {
        RetryParams params1 = RetryParams.defaultInstance();
        RetryParams params2 = RetryParams.builder().build();
        for (RetryParams params : Arrays.asList(params1, params2)) {
            Assert.assertEquals((long)1000L, (long)params.initialRetryDelayMillis());
            Assert.assertEquals((long)32000L, (long)params.maxRetryDelayMillis());
            Assert.assertEquals((double)2.0, (double)params.retryDelayBackoffFactor(), (double)0.0);
            Assert.assertEquals((long)6L, (long)params.retryMaxAttempts());
            Assert.assertEquals((long)3L, (long)params.retryMinAttempts());
            Assert.assertEquals((long)50000L, (long)params.totalRetryPeriodMillis());
        }
    }

    @Test
    public void testSetAndCopy() {
        RetryParams.Builder builder = RetryParams.builder();
        builder.initialRetryDelayMillis(101L);
        builder.maxRetryDelayMillis(102L);
        builder.retryDelayBackoffFactor(103.0);
        builder.retryMinAttempts(107);
        builder.retryMaxAttempts(108);
        builder.totalRetryPeriodMillis(109L);
        RetryParams params1 = builder.build();
        RetryParams params2 = new RetryParams.Builder(params1).build();
        for (RetryParams params : Arrays.asList(params1, params2)) {
            Assert.assertEquals((long)101L, (long)params.initialRetryDelayMillis());
            Assert.assertEquals((long)102L, (long)params.maxRetryDelayMillis());
            Assert.assertEquals((double)103.0, (double)params.retryDelayBackoffFactor(), (double)0.0);
            Assert.assertEquals((long)107L, (long)params.retryMinAttempts());
            Assert.assertEquals((long)108L, (long)params.retryMaxAttempts());
            Assert.assertEquals((long)109L, (long)params.totalRetryPeriodMillis());
        }
    }

    @Test
    public void testBadSettings() {
        RetryParams.Builder builder = RetryParams.builder();
        builder.initialRetryDelayMillis(-1L);
        builder = RetryParamsTest.assertFailure(builder);
        builder.maxRetryDelayMillis(RetryParams.defaultInstance().initialRetryDelayMillis() - 1L);
        builder = RetryParamsTest.assertFailure(builder);
        builder.retryDelayBackoffFactor(-1.0);
        builder = RetryParamsTest.assertFailure(builder);
        builder.retryMinAttempts(-1);
        builder = RetryParamsTest.assertFailure(builder);
        builder.retryMaxAttempts(RetryParams.defaultInstance().retryMinAttempts() - 1);
        builder = RetryParamsTest.assertFailure(builder);
        builder.totalRetryPeriodMillis(-1L);
        builder = RetryParamsTest.assertFailure(builder);
        builder.retryMaxAttempts(RetryParams.defaultInstance().retryMinAttempts());
        builder.maxRetryDelayMillis(RetryParams.defaultInstance().initialRetryDelayMillis());
        builder.build();
    }

    private static RetryParams.Builder assertFailure(RetryParams.Builder builder) {
        try {
            builder.build();
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return RetryParams.builder();
    }
}

