/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.AuthCredentials;
import com.google.cloud.BaseService;
import com.google.cloud.Clock;
import com.google.cloud.RetryParams;
import com.google.cloud.Service;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class ServiceOptionsTest {
    private static final String JSON_KEY = "{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\"\n}";
    private static final InputStream JSON_KEY_STREAM = new ByteArrayInputStream("{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\"\n}".getBytes());
    private static AuthCredentials authCredentials;
    private static final Clock TEST_CLOCK;
    private static final TestServiceOptions OPTIONS;
    private static final TestServiceOptions DEFAULT_OPTIONS;
    private static final TestServiceOptions OPTIONS_COPY;
    private static final String LIBRARY_NAME = "gcloud-java";
    private static final Pattern APPLICATION_NAME_PATTERN;

    @Test
    public void testBuilder() {
        Assert.assertSame((Object)authCredentials, (Object)OPTIONS.authCredentials());
        Assert.assertSame((Object)TEST_CLOCK, (Object)OPTIONS.clock());
        Assert.assertEquals((Object)"host", (Object)OPTIONS.host());
        Assert.assertEquals((Object)"project-id", (Object)OPTIONS.projectId());
        Assert.assertSame((Object)RetryParams.noRetries(), (Object)OPTIONS.retryParams());
        Assert.assertSame((Object)Clock.defaultClock(), (Object)DEFAULT_OPTIONS.clock());
        Assert.assertEquals((Object)"https://www.googleapis.com", (Object)DEFAULT_OPTIONS.host());
        Assert.assertSame((Object)RetryParams.defaultInstance(), (Object)DEFAULT_OPTIONS.retryParams());
    }

    @Test
    public void testGetProjectIdRequired() {
        Assert.assertTrue((boolean)OPTIONS.projectIdRequired());
    }

    @Test
    public void testService() {
        Assert.assertTrue((boolean)(OPTIONS.service() instanceof TestServiceImpl));
    }

    @Test
    public void testRpc() {
        Assert.assertTrue((boolean)(OPTIONS.rpc() instanceof DefaultTestServiceRpc));
    }

    @Test
    public void testBaseEquals() {
        Assert.assertEquals((Object)((Object)OPTIONS), (Object)((Object)OPTIONS_COPY));
        Assert.assertNotEquals((Object)((Object)DEFAULT_OPTIONS), (Object)((Object)OPTIONS));
    }

    @Test
    public void testLibraryName() {
        Assert.assertEquals((Object)LIBRARY_NAME, (Object)OPTIONS.libraryName());
    }

    @Test
    public void testApplicationName() {
        Assert.assertTrue((boolean)APPLICATION_NAME_PATTERN.matcher(OPTIONS.applicationName()).matches());
    }

    @Test
    public void testBaseHashCode() {
        Assert.assertEquals((long)OPTIONS.hashCode(), (long)OPTIONS_COPY.hashCode());
        Assert.assertNotEquals((long)DEFAULT_OPTIONS.hashCode(), (long)OPTIONS.hashCode());
    }

    static {
        try {
            authCredentials = AuthCredentials.createForJson((InputStream)JSON_KEY_STREAM);
        }
        catch (IOException e) {
            Assert.fail((String)"Couldn't create fake JSON credentials.");
        }
        TEST_CLOCK = new TestClock();
        OPTIONS = ((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)((TestServiceOptions.Builder)TestServiceOptions.builder().authCredentials(authCredentials)).clock(TEST_CLOCK)).host("host")).projectId("project-id")).retryParams(RetryParams.noRetries())).build();
        DEFAULT_OPTIONS = ((TestServiceOptions.Builder)TestServiceOptions.builder().projectId("project-id")).build();
        OPTIONS_COPY = OPTIONS.toBuilder().build();
        APPLICATION_NAME_PATTERN = Pattern.compile("gcloud-java(/[0-9]+.[0-9]+.[0-9]+)?");
    }

    private static class TestServiceOptions
    extends ServiceOptions<TestService, TestServiceRpc, TestServiceOptions> {
        private TestServiceOptions(Builder builder) {
            super(TestServiceFactory.class, TestServiceRpcFactory.class, (ServiceOptions.Builder)builder);
        }

        protected TestServiceFactory defaultServiceFactory() {
            return DefaultTestServiceFactory.INSTANCE;
        }

        protected TestServiceRpcFactory defaultRpcFactory() {
            return DefaultTestServiceRpcFactory.INSTANCE;
        }

        protected Set<String> scopes() {
            return null;
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        private static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object obj) {
            return obj instanceof TestServiceOptions && this.baseEquals((TestServiceOptions)((Object)obj));
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        private static class Builder
        extends ServiceOptions.Builder<TestService, TestServiceRpc, TestServiceOptions, Builder> {
            private Builder() {
            }

            private Builder(TestServiceOptions options) {
                super((ServiceOptions)options);
            }

            protected TestServiceOptions build() {
                return new TestServiceOptions(this);
            }
        }
    }

    private static class DefaultTestServiceRpc
    implements TestServiceRpc {
        DefaultTestServiceRpc(TestServiceOptions options) {
        }
    }

    private static interface TestServiceRpc {
    }

    private static class DefaultTestServiceRpcFactory
    implements TestServiceRpcFactory {
        private static final TestServiceRpcFactory INSTANCE = new DefaultTestServiceRpcFactory();

        private DefaultTestServiceRpcFactory() {
        }

        public TestServiceRpc create(TestServiceOptions options) {
            return new DefaultTestServiceRpc(options);
        }
    }

    private static interface TestServiceRpcFactory
    extends ServiceRpcFactory<TestServiceRpc, TestServiceOptions> {
    }

    private static class DefaultTestServiceFactory
    implements TestServiceFactory {
        private static final TestServiceFactory INSTANCE = new DefaultTestServiceFactory();

        private DefaultTestServiceFactory() {
        }

        public TestService create(TestServiceOptions options) {
            return new TestServiceImpl(options);
        }
    }

    private static interface TestServiceFactory
    extends ServiceFactory<TestService, TestServiceOptions> {
    }

    private static class TestServiceImpl
    extends BaseService<TestServiceOptions>
    implements TestService {
        private TestServiceImpl(TestServiceOptions options) {
            super((ServiceOptions)options);
        }
    }

    private static interface TestService
    extends Service<TestServiceOptions> {
    }

    private static class TestClock
    extends Clock {
        private TestClock() {
        }

        public long millis() {
            return 123456789L;
        }
    }
}

