/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.WaitForOption;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class WaitForOptionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final WaitForOption.CheckingPeriod CHECKING_PERIOD_OPTION = WaitForOption.checkEvery((long)42L, (TimeUnit)TimeUnit.MILLISECONDS);
    private static final WaitForOption.Timeout TIMEOUT_OPTION = WaitForOption.timeout((long)43L, (TimeUnit)TimeUnit.MILLISECONDS);

    @Test
    public void testCheckEvery() {
        Assert.assertEquals((Object)WaitForOption.OptionType.CHECKING_PERIOD, (Object)CHECKING_PERIOD_OPTION.optionType());
        Assert.assertEquals((long)42L, (long)CHECKING_PERIOD_OPTION.period());
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)CHECKING_PERIOD_OPTION.unit()));
    }

    @Test
    public void testCheckEvery_InvalidPeriod() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("checkEvery must be >= 0");
        WaitForOption.checkEvery((long)-1L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void testTimeout() {
        Assert.assertEquals((Object)WaitForOption.OptionType.TIMEOUT, (Object)TIMEOUT_OPTION.optionType());
        Assert.assertEquals((long)43L, (long)TIMEOUT_OPTION.timeoutMillis());
        WaitForOption.Timeout timeoutOption = WaitForOption.timeout((long)43L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEquals((long)43000L, (long)timeoutOption.timeoutMillis());
    }

    @Test
    public void testTimeout_InvalidTimeout() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("timeout must be >= 0");
        WaitForOption.timeout((long)-1L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Test
    public void testEqualsAndHashCode() {
        Assert.assertEquals((Object)CHECKING_PERIOD_OPTION, (Object)CHECKING_PERIOD_OPTION);
        Assert.assertEquals((Object)TIMEOUT_OPTION, (Object)TIMEOUT_OPTION);
        Assert.assertEquals((long)CHECKING_PERIOD_OPTION.hashCode(), (long)CHECKING_PERIOD_OPTION.hashCode());
        Assert.assertEquals((long)TIMEOUT_OPTION.hashCode(), (long)TIMEOUT_OPTION.hashCode());
        WaitForOption.CheckingPeriod checkingPeriodOption = WaitForOption.checkEvery((long)42L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)CHECKING_PERIOD_OPTION, (Object)checkingPeriodOption);
        Assert.assertEquals((long)CHECKING_PERIOD_OPTION.hashCode(), (long)checkingPeriodOption.hashCode());
        WaitForOption.Timeout timeoutOption = WaitForOption.timeout((long)43L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)TIMEOUT_OPTION, (Object)timeoutOption);
        Assert.assertEquals((long)TIMEOUT_OPTION.hashCode(), (long)timeoutOption.hashCode());
        Assert.assertNotEquals((Object)CHECKING_PERIOD_OPTION, (Object)TIMEOUT_OPTION);
        Assert.assertNotEquals((long)CHECKING_PERIOD_OPTION.hashCode(), (long)TIMEOUT_OPTION.hashCode());
        checkingPeriodOption = WaitForOption.checkEvery((long)43L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((Object)CHECKING_PERIOD_OPTION, (Object)checkingPeriodOption);
        Assert.assertNotEquals((long)CHECKING_PERIOD_OPTION.hashCode(), (long)checkingPeriodOption.hashCode());
        checkingPeriodOption = WaitForOption.checkEvery((long)42L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertNotEquals((Object)CHECKING_PERIOD_OPTION, (Object)checkingPeriodOption);
        Assert.assertNotEquals((long)CHECKING_PERIOD_OPTION.hashCode(), (long)checkingPeriodOption.hashCode());
        timeoutOption = WaitForOption.timeout((long)42L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((Object)TIMEOUT_OPTION, (Object)timeoutOption);
        Assert.assertNotEquals((long)TIMEOUT_OPTION.hashCode(), (long)timeoutOption.hashCode());
        timeoutOption = WaitForOption.timeout((long)43L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertNotEquals((Object)TIMEOUT_OPTION, (Object)timeoutOption);
        Assert.assertNotEquals((long)TIMEOUT_OPTION.hashCode(), (long)timeoutOption.hashCode());
    }

    @Test
    public void testGetOrDefault() {
        Assert.assertEquals((Object)CHECKING_PERIOD_OPTION, (Object)WaitForOption.CheckingPeriod.getOrDefault((WaitForOption[])new WaitForOption[]{CHECKING_PERIOD_OPTION, TIMEOUT_OPTION}));
        Assert.assertEquals((Object)TIMEOUT_OPTION, (Object)WaitForOption.Timeout.getOrDefault((WaitForOption[])new WaitForOption[]{CHECKING_PERIOD_OPTION, TIMEOUT_OPTION}));
        WaitForOption.CheckingPeriod checkingPeriod = WaitForOption.CheckingPeriod.getOrDefault((WaitForOption[])new WaitForOption[]{TIMEOUT_OPTION});
        Assert.assertEquals((long)500L, (long)checkingPeriod.period());
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)checkingPeriod.unit()));
        WaitForOption.Timeout timeout = WaitForOption.Timeout.getOrDefault((WaitForOption[])new WaitForOption[]{CHECKING_PERIOD_OPTION});
        Assert.assertEquals((long)-1L, (long)timeout.timeoutMillis());
    }

    @Test
    public void testCheckingPeriodGetOrDefault_DuplicateOption() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Duplicate option %s", CHECKING_PERIOD_OPTION));
        WaitForOption.CheckingPeriod.getOrDefault((WaitForOption[])new WaitForOption[]{CHECKING_PERIOD_OPTION, CHECKING_PERIOD_OPTION});
    }

    @Test
    public void testTimeoutGetOrDefault_DuplicateOption() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Duplicate option %s", TIMEOUT_OPTION));
        WaitForOption.Timeout.getOrDefault((WaitForOption[])new WaitForOption[]{TIMEOUT_OPTION, TIMEOUT_OPTION});
    }
}

