/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.nio;

import com.google.common.base.Stopwatch;
import com.google.common.io.BaseEncoding;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ParallelCountBytes {
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("--help")) {
            ParallelCountBytes.help();
            return;
        }
        for (String a : args) {
            ParallelCountBytes.countFile(a);
        }
    }

    private static void countFile(String fname) throws Exception {
        int blockIndex;
        int bufSize = 0x3200000;
        ArrayDeque<Future<WorkUnit>> work = new ArrayDeque<Future<WorkUnit>>();
        Path path = Paths.get(new URI(fname));
        long size = Files.size(path);
        System.out.println(fname + ": " + size + " bytes.");
        int nThreads = (int)Math.ceil((double)size / 5.24288E7);
        if (nThreads > 4) {
            nThreads = 4;
        }
        System.out.println("Reading the whole file using " + nThreads + " threads...");
        Stopwatch sw = Stopwatch.createStarted();
        long total = 0L;
        MessageDigest md = MessageDigest.getInstance("MD5");
        ExecutorService exec = Executors.newFixedThreadPool(nThreads);
        for (blockIndex = 0; blockIndex < nThreads; ++blockIndex) {
            work.add(exec.submit(new WorkUnit(Files.newByteChannel(path, new OpenOption[0]), 0x3200000, blockIndex)));
        }
        while (!work.isEmpty()) {
            WorkUnit full = (WorkUnit)((Future)work.remove()).get();
            md.update(full.buf.array(), 0, full.buf.position());
            total += (long)full.buf.position();
            if (full.buf.hasRemaining()) {
                full.close();
                continue;
            }
            work.add(exec.submit(full.resetForIndex(blockIndex++)));
        }
        exec.shutdown();
        long elapsed = sw.elapsed(TimeUnit.SECONDS);
        System.out.println("Read all " + total + " bytes in " + elapsed + "s. ");
        String hex = String.valueOf(BaseEncoding.base16().encode(md.digest()));
        System.out.println("The MD5 is: 0x" + hex);
        if (total != size) {
            System.out.println("Wait, this doesn't match! We saw " + total + " bytes, " + "yet the file size is listed at " + size + " bytes.");
        }
    }

    private static void help() {
        String[] help;
        for (String s : help = new String[]{"The argument is a <path>", "and we show the length of that file."}) {
            System.out.println(s);
        }
    }

    private static class WorkUnit
    implements Callable<WorkUnit>,
    Closeable {
        public final ByteBuffer buf;
        final SeekableByteChannel chan;
        final int blockSize;
        int blockIndex;

        public WorkUnit(SeekableByteChannel chan, int blockSize, int blockIndex) {
            this.chan = chan;
            this.buf = ByteBuffer.allocate(blockSize);
            this.blockSize = blockSize;
            this.blockIndex = blockIndex;
        }

        @Override
        public WorkUnit call() throws IOException {
            long pos = (long)this.blockSize * (long)this.blockIndex;
            if (pos > this.chan.size()) {
                return this;
            }
            this.chan.position(pos);
            while (this.chan.read(this.buf) > 0) {
            }
            return this;
        }

        public WorkUnit resetForIndex(int blockIndex) {
            this.blockIndex = blockIndex;
            this.buf.flip();
            return this;
        }

        @Override
        public void close() throws IOException {
            this.chan.close();
        }
    }
}

