/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.nio;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;

public class Stat {
    public static void main(String[] args) throws IOException {
        if (args.length == 0 || args[0].equals("--help")) {
            Stat.help();
            return;
        }
        if (args[0].equals("--list")) {
            Stat.listFilesystems();
            return;
        }
        if (args[0].equals("--check")) {
            Stat.checkGcs();
            return;
        }
        for (String a : args) {
            Stat.statFile(a);
        }
    }

    private static void statFile(String fname) {
        try {
            Path path = Paths.get(new URI(fname));
            long size = Files.size(path);
            System.out.println(fname + ": " + size + " bytes.");
        }
        catch (Exception ex) {
            System.out.println(fname + ": " + ex.toString());
        }
    }

    private static void help() {
        String[] help;
        for (String s : help = new String[]{"The arguments can be one of:", " * <path>", "   to display the length of that file.", "", " * --list", "   to list the filesystem providers.", "", " * --check", "   to double-check the Google Cloud Storage provider is installed.", "", "The purpose of this tool is to demonstrate that the gcloud NIO filesystem provider", "can add Google Cloud Storage support to programs not explicitly designed for it.", "", "This tool normally knows nothing of Google Cloud Storage. If you pass it --check", "or a Google Cloud Storage file name (e.g. gs://mybucket/myfile), it will show an error.", "However, by just adding the gcloud-nio jar as a dependency and recompiling, this tool is", "made aware of gs:// paths and can access files on the cloud.", "", "The gcloud NIO filesystem provider can similarly enable existing Java 7 programs", "to read and write cloud files, even if they have no special built-in cloud support."}) {
            System.out.println(s);
        }
    }

    private static void listFilesystems() {
        System.out.println("Installed filesystem providers:");
        for (FileSystemProvider p : FileSystemProvider.installedProviders()) {
            System.out.println("  " + p.getScheme());
        }
    }

    private static void checkGcs() {
        FileSystem fs = FileSystems.getFileSystem(URI.create("gs://domain-registry-alpha"));
        System.out.println("Success! We can instantiate a gs:// filesystem.");
        System.out.println("isOpen: " + fs.isOpen());
        System.out.println("isReadOnly: " + fs.isReadOnly());
    }
}

