/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import dagger.MapKey;
import dagger.android.AndroidInjectionKey;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

final class AndroidMapKeys {
    AndroidMapKeys() {
    }

    static ImmutableMap<Class<? extends Annotation>, TypeMirror> annotationsAndFrameworkTypes(Elements elements) {
        return ImmutableMap.copyOf(Stream.of(elements.getPackageElement("dagger.android"), elements.getPackageElement("dagger.android.support")).filter(packageElement -> packageElement != null).flatMap(packageElement -> ElementFilter.typesIn(packageElement.getEnclosedElements()).stream()).filter(AndroidMapKeys::isNotAndroidInjectionKey).filter(type -> MoreElements.isAnnotationPresent(type, MapKey.class)).filter(mapKey -> mapKey.getAnnotation(MapKey.class).unwrapValue()).flatMap(AndroidMapKeys::classForAnnotationElement).collect(Collectors.toMap(key -> key, key -> AndroidMapKeys.mapKeyValue(key, elements))));
    }

    private static boolean isNotAndroidInjectionKey(TypeElement type) {
        return !type.getQualifiedName().contentEquals(AndroidInjectionKey.class.getCanonicalName());
    }

    private static Stream<Class<? extends Annotation>> classForAnnotationElement(TypeElement type) {
        try {
            Class<?> clazz = Class.forName(type.getQualifiedName().toString());
            return Stream.of(clazz);
        }
        catch (ClassNotFoundException e) {
            return Stream.of(new Class[0]);
        }
    }

    private static TypeMirror mapKeyValue(Class<? extends Annotation> annotation, Elements elements) {
        List<ExecutableElement> mapKeyMethods = ElementFilter.methodsIn(elements.getTypeElement(annotation.getCanonicalName()).getEnclosedElements());
        TypeMirror returnType = ((ExecutableElement)Iterables.getOnlyElement(mapKeyMethods)).getReturnType();
        return ((WildcardType)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments())).getExtendsBound();
    }

    static Optional<String> injectedTypeFromMapKey(AnnotationMirror mapKey) {
        Object mapKeyClass = AnnotationMirrors.getAnnotationValue(mapKey, "value").getValue();
        if (mapKeyClass instanceof String) {
            return Optional.of((String)mapKeyClass);
        }
        if (mapKeyClass instanceof TypeMirror) {
            TypeElement type = MoreTypes.asTypeElement((TypeMirror)mapKeyClass);
            return Optional.of(type.getQualifiedName().toString());
        }
        return Optional.empty();
    }
}

