/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.googlejavaformat.java.filer.FormattingFiler;
import dagger.android.processor.AndroidInjectorDescriptor;
import dagger.android.processor.AndroidMapKeyValidator;
import dagger.android.processor.ContributesAndroidInjectorGenerator;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

public final class AndroidProcessor
extends BasicAnnotationProcessor {
    private static final String FLAG_EXPERIMENTAL_USE_STRING_KEYS = "dagger.android.experimentalUseStringKeys";

    @Override
    protected Iterable<? extends BasicAnnotationProcessor.ProcessingStep> initSteps() {
        FormattingFiler filer = new FormattingFiler(this.processingEnv.getFiler());
        Messager messager = this.processingEnv.getMessager();
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        return ImmutableList.of((Object)new AndroidMapKeyValidator(elements, types, messager), (Object)new ContributesAndroidInjectorGenerator(new AndroidInjectorDescriptor.Validator(types, elements, messager), this.useStringKeys(), (Filer)filer, elements, this.processingEnv.getSourceVersion()));
    }

    private boolean useStringKeys() {
        if (!this.processingEnv.getOptions().containsKey(FLAG_EXPERIMENTAL_USE_STRING_KEYS)) {
            return false;
        }
        String flagValue = this.processingEnv.getOptions().get(FLAG_EXPERIMENTAL_USE_STRING_KEYS);
        if (flagValue == null || Ascii.equalsIgnoreCase((CharSequence)flagValue, (CharSequence)"true")) {
            return true;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)flagValue, (CharSequence)"false")) {
            return false;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Unknown flag value: %s. %s must be set to either 'true' or 'false'.", flagValue, FLAG_EXPERIMENTAL_USE_STRING_KEYS));
        return false;
    }

    @Override
    protected void postRound(RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() && this.useStringKeys()) {
            try (Writer writer = this.createProguardFile();){
                writer.write(Joiner.on((String)"\n").join((Object)"-identifiernamestring class dagger.android.internal.AndroidInjectionKeys {", (Object)"  java.lang.String of(java.lang.String);", new Object[]{"}"}));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Writer createProguardFile() throws IOException {
        return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/proguard/dagger.android.AndroidInjectionKeys", new Element[0]).openWriter();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return ImmutableSet.of((Object)FLAG_EXPERIMENTAL_USE_STRING_KEYS);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

