/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.MapKey;
import dagger.android.processor.AndroidMapKeys;
import dagger.android.processor.MoreDaggerElements;
import dagger.android.processor.TypeNames;
import dagger.android.shaded.auto.common.AnnotationMirrors;
import dagger.android.shaded.auto.common.BasicAnnotationProcessor;
import dagger.android.shaded.auto.common.MoreElements;
import dagger.internal.codegen.langmodel.DaggerElements;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class AndroidMapKeyValidator
implements BasicAnnotationProcessor.Step {
    private static final ImmutableMap<String, ClassName> SUPPORTED_ANNOTATIONS = ImmutableMap.of((Object)TypeNames.ANDROID_INJECTION_KEY.toString(), (Object)TypeNames.ANDROID_INJECTION_KEY, (Object)TypeNames.CLASS_KEY.toString(), (Object)TypeNames.CLASS_KEY);
    private final Elements elements;
    private final Types types;
    private final Messager messager;

    AndroidMapKeyValidator(Elements elements, Types types, Messager messager) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
    }

    public ImmutableSet<String> annotations() {
        return SUPPORTED_ANNOTATIONS.keySet();
    }

    public ImmutableSet<Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
        ImmutableSet.Builder deferredElements = ImmutableSet.builder();
        elementsByAnnotation.entries().forEach(entry -> {
            try {
                this.validateMethod((String)entry.getKey(), MoreElements.asExecutable((Element)entry.getValue()));
            }
            catch (TypeNotPresentException e) {
                deferredElements.add((Object)((Element)entry.getValue()));
            }
        });
        return deferredElements.build();
    }

    private void validateMethod(String annotation, ExecutableElement method) {
        SuppressWarnings suppressedWarnings;
        if (!Sets.union((Set)DaggerElements.getAnnotatedAnnotations((Element)method, (ClassName)TypeNames.QUALIFIER), (Set)DaggerElements.getAnnotatedAnnotations((Element)method, (ClassName)TypeNames.QUALIFIER_JAVAX)).isEmpty()) {
            return;
        }
        TypeMirror returnType = method.getReturnType();
        if (!this.types.isAssignable(this.types.erasure(returnType), this.factoryElement().asType())) {
            return;
        }
        if (!(Sets.union((Set)DaggerElements.getAnnotatedAnnotations((Element)method, (ClassName)TypeNames.SCOPE), (Set)DaggerElements.getAnnotatedAnnotations((Element)method, (ClassName)TypeNames.SCOPE_JAVAX)).isEmpty() || (suppressedWarnings = method.getAnnotation(SuppressWarnings.class)) != null && ImmutableSet.copyOf((Object[])suppressedWarnings.value()).contains((Object)"dagger.android.ScopedInjectorFactory"))) {
            AnnotationMirror mapKeyAnnotation = (AnnotationMirror)Iterables.getOnlyElement(AnnotationMirrors.getAnnotatedAnnotations((Element)method, MapKey.class));
            TypeElement mapKeyValueElement = this.elements.getTypeElement(AndroidMapKeys.injectedTypeFromMapKey(mapKeyAnnotation).get());
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s bindings should not be scoped. Scoping this method may leak instances of %s.", TypeNames.ANDROID_INJECTOR_FACTORY.canonicalName(), mapKeyValueElement.getQualifiedName()), method);
        }
        this.validateReturnType(method);
        if (MoreDaggerElements.isAnnotationPresent(method, TypeNames.BINDS) && method.getParameters().size() == 1) {
            this.validateMapKeyMatchesBindsParameter(annotation, method);
        }
    }

    private void validateReturnType(ExecutableElement method) {
        DeclaredType requiredReturnType;
        TypeMirror returnType = method.getReturnType();
        if (!this.types.isSameType(returnType, requiredReturnType = this.injectorFactoryOf(this.types.getWildcardType(null, null)))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s should bind %s, not %s. See https://dagger.dev/android", method, requiredReturnType, returnType), method);
        }
    }

    private void validateMapKeyMatchesBindsParameter(String annotation, ExecutableElement method) {
        AnnotationMirror annotationMirror;
        TypeMirror mapKeyType;
        TypeMirror parameterType = ((VariableElement)Iterables.getOnlyElement(method.getParameters())).asType();
        if (!this.types.isAssignable(parameterType, this.injectorFactoryOf(mapKeyType = this.elements.getTypeElement(AndroidMapKeys.injectedTypeFromMapKey(annotationMirror = MoreDaggerElements.getAnnotationMirror(method, (ClassName)SUPPORTED_ANNOTATIONS.get((Object)annotation)).get()).get()).asType()))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s does not implement AndroidInjector<%s>", parameterType, mapKeyType), method, annotationMirror);
        }
    }

    private DeclaredType injectorFactoryOf(TypeMirror implementationType) {
        return this.types.getDeclaredType(this.factoryElement(), implementationType);
    }

    private TypeElement factoryElement() {
        return this.elements.getTypeElement(TypeNames.ANDROID_INJECTOR_FACTORY.canonicalName());
    }
}

