/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import dagger.android.processor.AndroidMapKeys;
import dagger.android.processor.TypeNames;
import dagger.internal.codegen.xprocessing.DaggerElements;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.DaggerType;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.model.Key;
import java.util.Formatter;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;

@AutoService(value={BindingGraphPlugin.class})
public final class DuplicateAndroidInjectorsChecker
implements BindingGraphPlugin {
    private DaggerProcessingEnv processingEnv;

    public void init(DaggerProcessingEnv processingEnv, Map<String, String> options) {
        this.processingEnv = processingEnv;
    }

    public void visitGraph(BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        for (Binding binding : graph.bindings()) {
            if (!this.isDispatchingAndroidInjector(binding)) continue;
            this.validateMapKeyUniqueness(binding, graph, diagnosticReporter);
        }
    }

    private boolean isDispatchingAndroidInjector(Binding binding) {
        Key key = binding.key();
        return XTypes.isTypeOf((XType)DaggerElements.toXProcessing((DaggerType)key.type(), (DaggerProcessingEnv)this.processingEnv), (ClassName)TypeNames.DISPATCHING_ANDROID_INJECTOR) && !key.qualifier().isPresent();
    }

    private void validateMapKeyUniqueness(Binding dispatchingAndroidInjector, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        ImmutableSet injectorFactories = this.injectorMapDependencies(dispatchingAndroidInjector, graph).flatMap(injectorFactoryMap -> graph.requestedBindings(injectorFactoryMap).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf));
        ImmutableListMultimap.Builder mapKeyIndex = ImmutableListMultimap.builder();
        for (Binding injectorFactory : injectorFactories) {
            XAnnotation mapKey = this.mapKey(injectorFactory).get();
            Optional<String> injectedType2 = AndroidMapKeys.injectedTypeFromMapKey(mapKey);
            if (injectedType2.isPresent()) {
                mapKeyIndex.put((Object)injectedType2.get(), (Object)injectorFactory);
                continue;
            }
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)injectorFactory, "Unrecognized class: %s", (Object)mapKey, new Object[0]);
        }
        Map duplicates = Maps.filterValues((Map)Multimaps.asMap((ListMultimap)mapKeyIndex.build()), bindings -> bindings.size() > 1);
        if (!duplicates.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Multiple injector factories bound for the same type:\n");
            Formatter formatter = new Formatter(errorMessage);
            duplicates.forEach((injectedType, duplicateFactories) -> {
                formatter.format("  %s:\n", injectedType);
                duplicateFactories.forEach(duplicate -> formatter.format("    %s\n", duplicate));
            });
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)dispatchingAndroidInjector, errorMessage.toString());
        }
    }

    private Stream<Binding> injectorMapDependencies(Binding binding, BindingGraph graph) {
        return graph.requestedBindings(binding).stream().filter(requestedBinding -> requestedBinding.kind().equals((Object)BindingKind.MULTIBOUND_MAP)).filter(requestedBinding -> {
            XType valueType = (XType)DaggerElements.toXProcessing((DaggerType)requestedBinding.key().type(), (DaggerProcessingEnv)this.processingEnv).getTypeArguments().get(1);
            if (!XTypes.isTypeOf((XType)valueType, (ClassName)TypeNames.PROVIDER) || !XTypes.isDeclared((XType)valueType)) {
                return false;
            }
            XType providedType = (XType)valueType.getTypeArguments().get(0);
            return XTypes.isTypeOf((XType)providedType, (ClassName)TypeNames.ANDROID_INJECTOR_FACTORY);
        });
    }

    private Optional<XAnnotation> mapKey(Binding binding) {
        return binding.bindingElement().map(bindingElement -> XElements.getAnnotatedAnnotations((XAnnotated)DaggerElements.toXProcessing((DaggerElement)bindingElement, (DaggerProcessingEnv)this.processingEnv), (ClassName)TypeNames.MAP_KEY)).flatMap(annotations -> annotations.isEmpty() ? Optional.empty() : Optional.of((XAnnotation)Iterables.getOnlyElement((Iterable)annotations)));
    }

    public String pluginName() {
        return "Dagger/Android/DuplicateAndroidInjectors";
    }
}

