/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.RangeSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

abstract class FileToFormat {
    private final ImmutableRangeSet<Integer> lineRanges;
    private final ImmutableList<Integer> offsets;
    private final ImmutableList<Integer> lengths;

    public FileToFormat(RangeSet<Integer> lineRanges, List<Integer> offsets, List<Integer> lengths) {
        this.lineRanges = ImmutableRangeSet.copyOf(lineRanges);
        this.offsets = ImmutableList.copyOf(offsets);
        this.lengths = ImmutableList.copyOf(lengths);
    }

    public abstract String fileName();

    public abstract InputStream inputStream() throws IOException;

    public ImmutableRangeSet<Integer> lineRanges() {
        return this.lineRanges;
    }

    public ImmutableList<Integer> offsets() {
        return this.offsets;
    }

    public ImmutableList<Integer> lengths() {
        return this.lengths;
    }
}

