/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.io.CharStreams;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.java.FileToFormat;
import com.google.googlejavaformat.java.FileToFormatStdin;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaCommentsHelper;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.JavaOutput;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class FormatFileCallable
implements Callable<Boolean> {
    private final FileToFormat fileToFormat;
    private final Object outputLock;
    private final JavaFormatterOptions options;
    private final boolean inPlace;
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;

    FormatFileCallable(FileToFormat fileToFormat, Object outputLock, JavaFormatterOptions options, boolean inPlace, PrintWriter outWriter, PrintWriter errWriter) {
        Preconditions.checkArgument((!inPlace || !(fileToFormat instanceof FileToFormatStdin) ? 1 : 0) != 0, (Object)"Cannot format stdin in place");
        this.fileToFormat = (FileToFormat)Preconditions.checkNotNull((Object)fileToFormat);
        this.outputLock = Preconditions.checkNotNull((Object)outputLock);
        this.options = options;
        this.inPlace = inPlace;
        this.outWriter = (PrintWriter)Preconditions.checkNotNull((Object)outWriter);
        this.errWriter = (PrintWriter)Preconditions.checkNotNull((Object)errWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        TreeRangeSet tokens;
        JavaInput javaInput;
        String inputString = this.readInput();
        if (inputString == null) {
            return false;
        }
        if (this.options.sortImports() != JavaFormatterOptions.SortImports.NO) {
            String reordered = this.reorderImports(inputString);
            if (reordered == null) {
                return false;
            }
            if (this.options.sortImports() == JavaFormatterOptions.SortImports.ONLY) {
                if (reordered.equals(inputString)) {
                    return true;
                }
                return this.writeString(reordered);
            }
            inputString = reordered;
        }
        try {
            javaInput = new JavaInput(this.fileToFormat.fileName(), inputString);
            tokens = TreeRangeSet.create();
            for (Range lineRange : this.fileToFormat.lineRanges().asRanges()) {
                tokens.add(javaInput.lineRangeToTokenRange((Range<Integer>)lineRange));
            }
            for (int i = 0; i < this.fileToFormat.offsets().size(); ++i) {
                tokens.add(javaInput.characterRangeToTokenRange((Integer)this.fileToFormat.offsets().get(i), (Integer)this.fileToFormat.lengths().get(i)));
            }
        }
        catch (FormatterException e) {
            Object lineRange = this.outputLock;
            synchronized (lineRange) {
                this.errWriter.append(this.fileToFormat.fileName()).append(": error: ").append(e.getMessage()).append('\n').flush();
            }
            return false;
        }
        if (tokens.isEmpty() && this.fileToFormat.lineRanges().asRanges().isEmpty() && this.fileToFormat.offsets().isEmpty()) {
            tokens.add(Range.all());
        }
        final JavaOutput javaOutput = new JavaOutput(javaInput, new JavaCommentsHelper(this.options));
        ArrayList<FormatterDiagnostic> errors = new ArrayList<FormatterDiagnostic>();
        Formatter.format(javaInput, javaOutput, this.options, errors);
        if (!errors.isEmpty()) {
            Object object = this.outputLock;
            synchronized (object) {
                for (FormatterDiagnostic error : errors) {
                    this.errWriter.println(error.toString());
                }
            }
            return false;
        }
        Write writeTokens = new Write((RangeSet)tokens){
            final /* synthetic */ RangeSet val$tokens;
            {
                this.val$tokens = rangeSet;
            }

            @Override
            public void write(Writer writer) throws IOException {
                javaOutput.writeMerged(writer, (RangeSet<Integer>)this.val$tokens);
            }
        };
        return this.writeOutput(writeTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String readInput() {
        try (InputStream in = this.fileToFormat.inputStream();){
            String throwable = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
            return throwable;
        }
        catch (IOException e) {
            Object object = this.outputLock;
            synchronized (object) {
                this.errWriter.append(this.fileToFormat.fileName()).append(": could not read file: ").append(e.getMessage()).append('\n').flush();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String reorderImports(String inputString) {
        try {
            return ImportOrderer.reorderImports(this.fileToFormat.fileName(), inputString);
        }
        catch (FormatterException e) {
            Object object = this.outputLock;
            synchronized (object) {
                this.errWriter.append(this.fileToFormat.fileName()).append(": error sorting imports: ").append(e.getMessage()).append('\n').flush();
            }
            return null;
        }
    }

    private boolean writeString(final String s) {
        return this.writeOutput(new Write(){

            @Override
            public void write(Writer writer) throws IOException {
                writer.write(s);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeOutput(Write write) {
        Object object;
        if (!this.inPlace) {
            Object object2 = this.outputLock;
            synchronized (object2) {
                try {
                    write.write(this.outWriter);
                }
                catch (IOException e) {
                    this.errWriter.append("cannot write output: " + e.getMessage()).flush();
                }
                this.outWriter.flush();
                return true;
            }
        }
        String tempFileName = this.fileToFormat.fileName() + '#';
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tempFileName)), StandardCharsets.UTF_8);
            object = null;
            try {
                write.write(writer);
                this.outWriter.flush();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
        catch (IOException e) {
            Object object3 = this.outputLock;
            synchronized (object3) {
                this.errWriter.append(tempFileName).append(": cannot write temp file: ").append(e.getMessage()).append('\n').flush();
            }
            return false;
        }
        try {
            Files.move(Paths.get(tempFileName, new String[0]), Paths.get(this.fileToFormat.fileName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            object = this.outputLock;
            synchronized (object) {
                this.errWriter.append(tempFileName).append(": cannot rename temp file: ").append(e.getMessage()).append('\n').flush();
            }
            return false;
        }
        return true;
    }

    static interface Write {
        public void write(Writer var1) throws IOException;
    }
}

