/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.FormatterDiagnostic;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class FormattingError
extends Error {
    private final ImmutableList<FormatterDiagnostic> diagnostics;
    private static final Function<Diagnostic<?>, FormatterDiagnostic> TO_FORMATTER_DIAGNOSTIC = new Function<Diagnostic<?>, FormatterDiagnostic>(){

        public FormatterDiagnostic apply(Diagnostic<?> input) {
            return FormatterDiagnostic.create((int)input.getLineNumber(), (int)input.getColumnNumber(), input.getMessage(Locale.ENGLISH));
        }
    };

    public FormattingError(FormatterDiagnostic diagnostic) {
        this((Iterable<FormatterDiagnostic>)ImmutableList.of((Object)diagnostic));
    }

    public FormattingError(Iterable<FormatterDiagnostic> diagnostics) {
        super(Joiner.on((String)"\n").join(diagnostics) + "\n");
        this.diagnostics = ImmutableList.copyOf(diagnostics);
    }

    public ImmutableList<FormatterDiagnostic> diagnostics() {
        return this.diagnostics;
    }

    public static FormattingError fromJavacDiagnostics(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return new FormattingError(Iterables.transform(diagnostics, TO_FORMATTER_DIAGNOSTIC));
    }
}

