/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.ValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;

public class IdValidatorHelper
extends ValidatorHelper {
    private final IdAnnotationHelper idAnnotationHelper;

    public IdValidatorHelper(IdAnnotationHelper idAnnotationHelper) {
        super(idAnnotationHelper);
        this.idAnnotationHelper = idAnnotationHelper;
    }

    public void resIdsExist(Element element, IRClass.Res res, FallbackStrategy fallbackStrategy, IsValid valid) {
        block5: {
            int[] resIds;
            block2: {
                String[] resNames;
                block3: {
                    block4: {
                        Class<? extends Annotation> target = this.idAnnotationHelper.getTarget();
                        resIds = this.idAnnotationHelper.extractAnnotationResIdValueParameter(element, target);
                        if (!this.idAnnotationHelper.defaultResIdValue(resIds)) break block2;
                        resNames = this.idAnnotationHelper.extractAnnotationResNameParameter(element, target);
                        if (!this.idAnnotationHelper.defaultResName(resNames)) break block3;
                        if (fallbackStrategy != FallbackStrategy.USE_ELEMENT_NAME) break block4;
                        String elementName = this.idAnnotationHelper.extractElementName(element, target);
                        if (this.idAnnotationHelper.containsField(elementName, res)) break block5;
                        valid.invalidate();
                        this.annotationHelper.printAnnotationError(element, "Resource name not found in R." + res.rName() + ": " + elementName);
                        break block5;
                    }
                    if (fallbackStrategy != FallbackStrategy.NEED_RES_ID) break block5;
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "%s needs an annotation value");
                    break block5;
                }
                for (String resName : resNames) {
                    if (this.idAnnotationHelper.containsField(resName, res)) continue;
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "Resource name not found in R." + res.rName() + ": " + resName);
                }
                break block5;
            }
            for (int resId : resIds) {
                if (this.idAnnotationHelper.containsIdValue(resId, res)) continue;
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "Resource id value not found in R." + res.rName() + ": " + resId);
            }
        }
    }

    public void annotationParameterIsOptionalValidResId(Element element, IRClass.Res res, String parameterName, IsValid valid) {
        Integer resId = (Integer)this.annotationHelper.extractAnnotationParameter(element, parameterName);
        if (!resId.equals(-1) && !this.idAnnotationHelper.containsIdValue(resId, res)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Id value not found in R." + res.rName() + ": " + resId);
        }
    }

    public void uniqueId(Element element, AnnotationElements validatedElements, IsValid valid) {
        if (valid.isValid()) {
            List<String> annotationQualifiedIds = this.idAnnotationHelper.extractAnnotationResources(element, IRClass.Res.ID, true);
            Element elementEnclosingElement = element.getEnclosingElement();
            Set<? extends Element> annotatedElements = validatedElements.getRootAnnotatedElements(this.annotationHelper.getTarget().getName());
            for (Element element2 : annotatedElements) {
                Element uniqueCheckEnclosingElement = element2.getEnclosingElement();
                if (!((Object)elementEnclosingElement).equals(uniqueCheckEnclosingElement)) continue;
                List<String> checkQualifiedIds = this.idAnnotationHelper.extractAnnotationResources(element2, IRClass.Res.ID, true);
                for (String checkQualifiedId : checkQualifiedIds) {
                    for (String annotationQualifiedId : annotationQualifiedIds) {
                        if (!annotationQualifiedId.equals(checkQualifiedId)) continue;
                        valid.invalidate();
                        String annotationSimpleId = annotationQualifiedId.substring(annotationQualifiedId.lastIndexOf(46) + 1);
                        this.annotationHelper.printAnnotationError(element, "The id " + annotationSimpleId + " is already used on the following " + this.annotationHelper.annotationName() + " method: " + element2);
                        return;
                    }
                }
            }
        }
    }

    public void annotationValuePositiveAndInAShort(Element element, IsValid valid, int value) {
        if (value < 0 || value > 65535) {
            this.annotationHelper.printAnnotationError(element, "Due to a restriction in the fragment API, the requestCode has to be a positive integer inferior or equal to 0xFFFF");
            valid.invalidate();
        }
    }

    public static enum FallbackStrategy {
        USE_ELEMENT_NAME,
        ALLOW_NO_RES_ID,
        NEED_RES_ID;

    }
}

