/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.Bean;
import com.googlecode.androidannotations.annotations.NonConfigurationInstance;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class BeanProcessor
implements DecoratingElementProcessor {
    private TargetAnnotationHelper annotationHelper;

    public BeanProcessor(ProcessingEnvironment processingEnv) {
        this.annotationHelper = new TargetAnnotationHelper(processingEnv, this.getTarget());
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Bean.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        boolean hasNonConfigurationInstanceAnnotation;
        DeclaredType targetAnnotationClassValue = this.annotationHelper.extractAnnotationClassParameter(element);
        TypeMirror elementType = targetAnnotationClassValue != null ? targetAnnotationClassValue : element.asType();
        String fieldName = element.getSimpleName().toString();
        String typeQualifiedName = ((Object)elementType).toString();
        JClass injectedClass = holder.refClass(typeQualifiedName + "_");
        JFieldRef beanField = JExpr.ref(fieldName);
        JBlock body = holder.init.body();
        boolean bl = hasNonConfigurationInstanceAnnotation = element.getAnnotation(NonConfigurationInstance.class) != null;
        if (hasNonConfigurationInstanceAnnotation) {
            body = body._if(beanField.eq(JExpr._null()))._then();
        }
        JInvocation getInstance = injectedClass.staticInvoke("getInstance_").arg(holder.contextRef);
        body.assign(beanField, getInstance);
        if (holder.afterSetContentView != null) {
            body = holder.afterSetContentView.body();
            body.invoke((JExpression)JExpr.cast(injectedClass, beanField), holder.afterSetContentView);
        }
    }
}

