/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.ItemSelect;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ItemSelectedProcessor
implements DecoratingElementProcessor {
    private IdAnnotationHelper helper;

    public ItemSelectedProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return ItemSelect.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        EBeansHolder.Classes classes = holder.classes();
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, IRClass.Res.ID, true);
        JDefinedClass onItemSelectedListenerClass = codeModel.anonymousClass(classes.ON_ITEM_SELECTED_LISTENER);
        JMethod onItemSelectedMethod = onItemSelectedListenerClass.method(1, codeModel.VOID, "onItemSelected");
        onItemSelectedMethod.annotate(Override.class);
        JClass narrowAdapterViewClass = classes.ADAPTER_VIEW.narrow(codeModel.wildcard());
        JVar onItemClickParentParam = onItemSelectedMethod.param(narrowAdapterViewClass, "parent");
        onItemSelectedMethod.param(classes.VIEW, "view");
        JVar onItemClickPositionParam = onItemSelectedMethod.param(codeModel.INT, "position");
        onItemSelectedMethod.param(codeModel.LONG, "id");
        JInvocation itemSelectedCall = onItemSelectedMethod.body().invoke(methodName);
        itemSelectedCall.arg(JExpr.TRUE);
        boolean hasItemParameter = parameters.size() == 2;
        boolean secondParameterIsInt = false;
        String secondParameterQualifiedName = null;
        if (hasItemParameter) {
            VariableElement secondParameter = parameters.get(1);
            TypeMirror secondParameterType = secondParameter.asType();
            secondParameterQualifiedName = ((Object)secondParameterType).toString();
            boolean bl = secondParameterIsInt = secondParameterType.getKind() == TypeKind.INT;
        }
        if (hasItemParameter) {
            if (secondParameterIsInt) {
                itemSelectedCall.arg(onItemClickPositionParam);
            } else {
                itemSelectedCall.arg(JExpr.cast(holder.refClass(secondParameterQualifiedName), JExpr.invoke((JExpression)onItemClickParentParam, "getAdapter").invoke("getItem").arg(onItemClickPositionParam)));
            }
        }
        JMethod onNothingSelectedMethod = onItemSelectedListenerClass.method(1, codeModel.VOID, "onNothingSelected");
        onNothingSelectedMethod.annotate(Override.class);
        onNothingSelectedMethod.param(narrowAdapterViewClass, "parent");
        JInvocation nothingSelectedCall = onNothingSelectedMethod.body().invoke(methodName);
        nothingSelectedCall.arg(JExpr.FALSE);
        if (hasItemParameter) {
            if (secondParameterIsInt) {
                nothingSelectedCall.arg(JExpr.lit(-1));
            } else {
                nothingSelectedCall.arg(JExpr._null());
            }
        }
        for (JFieldRef idRef : idsRefs) {
            JBlock body = holder.afterSetContentView.body();
            JInvocation findViewById = JExpr.invoke("findViewById");
            body.add(JExpr.invoke((JExpression)JExpr.cast(narrowAdapterViewClass, findViewById.arg(idRef)), "setOnItemSelectedListener").arg(JExpr._new(onItemSelectedListenerClass)));
        }
    }
}

