/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.rclass;

import com.googlecode.androidannotations.helper.CaseHelper;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.rclass.IRInnerClass;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JFieldRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public class RInnerClass
implements IRInnerClass {
    private final Map<Integer, String> idQualifiedNamesByIdValues = new HashMap<Integer, String>();
    private final Set<String> idQualifiedNames = new HashSet<String>();
    private final String rInnerQualifiedName;

    public RInnerClass(TypeElement rInnerTypeElement) {
        if (rInnerTypeElement != null) {
            this.rInnerQualifiedName = rInnerTypeElement.getQualifiedName().toString();
            List<? extends Element> idEnclosedElements = rInnerTypeElement.getEnclosedElements();
            List<VariableElement> idFields = ElementFilter.fieldsIn(idEnclosedElements);
            for (VariableElement idField : idFields) {
                TypeKind fieldType = idField.asType().getKind();
                if (!fieldType.isPrimitive() || !fieldType.equals((Object)TypeKind.INT)) continue;
                String idQualifiedName = this.rInnerQualifiedName + "." + idField.getSimpleName();
                this.idQualifiedNames.add(idQualifiedName);
                Integer idFieldId = (Integer)idField.getConstantValue();
                if (idFieldId == null) continue;
                this.idQualifiedNamesByIdValues.put(idFieldId, idQualifiedName);
            }
        } else {
            this.rInnerQualifiedName = "";
        }
    }

    @Override
    public boolean containsIdValue(Integer idValue) {
        return this.idQualifiedNamesByIdValues.containsKey(idValue);
    }

    @Override
    public String getIdQualifiedName(Integer idValue) {
        return this.idQualifiedNamesByIdValues.get(idValue);
    }

    @Override
    public boolean containsField(String name) {
        boolean containsField = this.idQualifiedNames.contains(this.rInnerQualifiedName + "." + name);
        if (!containsField) {
            String snakeCaseName = CaseHelper.camelCaseToSnakeCase(name);
            containsField = this.idQualifiedNames.contains(this.rInnerQualifiedName + "." + snakeCaseName);
        }
        return containsField;
    }

    @Override
    public String getIdQualifiedName(String name) {
        String idQualifiedName = this.rInnerQualifiedName + "." + name;
        if (this.idQualifiedNames.contains(idQualifiedName)) {
            return idQualifiedName;
        }
        String snakeCaseName = CaseHelper.camelCaseToSnakeCase(name);
        idQualifiedName = this.rInnerQualifiedName + "." + snakeCaseName;
        if (this.idQualifiedNames.contains(idQualifiedName)) {
            return idQualifiedName;
        }
        return null;
    }

    @Override
    public JFieldRef getIdStaticRef(Integer idValue, EBeanHolder holder) {
        String layoutFieldQualifiedName = this.getIdQualifiedName(idValue);
        return RInnerClass.extractIdStaticRef(holder, layoutFieldQualifiedName);
    }

    @Override
    public JFieldRef getIdStaticRef(String name, EBeanHolder holder) {
        String layoutFieldQualifiedName = this.getIdQualifiedName(name);
        return RInnerClass.extractIdStaticRef(holder, layoutFieldQualifiedName);
    }

    public static JFieldRef extractIdStaticRef(EBeanHolder holder, String layoutFieldQualifiedName) {
        if (layoutFieldQualifiedName != null) {
            int fieldSuffix = layoutFieldQualifiedName.lastIndexOf(46);
            String fieldName = layoutFieldQualifiedName.substring(fieldSuffix + 1);
            String rInnerClassName = layoutFieldQualifiedName.substring(0, fieldSuffix);
            JClass refClass = holder.refClass(rInnerClassName);
            return refClass.staticRef(fieldName);
        }
        return null;
    }
}

