/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.symmetric.EWAHPointer;
import com.googlecode.javaewah.symmetric.UpdateableBitmapFunction;
import java.util.Arrays;

public class ThresholdFuncBitmap
extends UpdateableBitmapFunction {
    int min;
    long[] buffers;
    int bufferUsed;
    private static int[] bufcounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap(int min) {
        this.min = min;
        this.buffers = new long[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage out, int runbegin, int runend) {
        int runlength = runend - runbegin;
        if (this.hammingWeight >= this.min) {
            out.addStreamOfEmptyWords(true, runlength);
            return;
        }
        if (this.litWeight + this.hammingWeight < this.min) {
            out.addStreamOfEmptyWords(false, runlength);
        } else {
            int deficit = this.min - this.hammingWeight;
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed > this.buffers.length) {
                this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
            }
            for (int i = 0; i < runlength; ++i) {
                int p = 0;
                for (EWAHPointer R : this.getLiterals()) {
                    this.buffers[p++] = R.iterator.getLiteralWordAt(i + runbegin - R.beginOfRun());
                }
                long result = ThresholdFuncBitmap.threshold4(deficit, this.buffers, this.bufferUsed);
                out.add(result);
            }
        }
    }

    private static long threshold2buf(int T, long[] buffers, int bufUsed) {
        long result = 0L;
        int[] counters = bufcounters;
        System.arraycopy(zeroes64, 0, counters, 0, 64);
        for (int k = 0; k < bufUsed; ++k) {
            long t;
            for (long bitset = buffers[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                int n = Long.bitCount(t - 1L);
                counters[n] = counters[n] + 1;
            }
        }
        for (int pos = 0; pos < 64; ++pos) {
            if (counters[pos] < T) continue;
            result |= 1L << pos;
        }
        return result;
    }

    private static long threshold3(int T, long[] buffers, int bufUsed) {
        if (buffers.length == 0) {
            return 0L;
        }
        long[] v = new long[T];
        v[0] = buffers[0];
        for (int k = 1; k < bufUsed; ++k) {
            long c = buffers[k];
            int j = T - 1;
            while (j >= 1) {
                long ttemp = c;
                int n = j--;
                v[n] = v[n] | (ttemp &= v[j - 1]);
            }
            v[0] = v[0] | c;
        }
        return v[T - 1];
    }

    private static long threshold4(int T, long[] buffers, int bufUsed) {
        if (T >= 128) {
            return ThresholdFuncBitmap.threshold2buf(T, buffers, bufUsed);
        }
        int B = 0;
        for (int k = 0; k < bufUsed; ++k) {
            B += Long.bitCount(buffers[k]);
        }
        if (2 * B >= bufUsed * T) {
            return ThresholdFuncBitmap.threshold3(T, buffers, bufUsed);
        }
        return ThresholdFuncBitmap.threshold2buf(T, buffers, bufUsed);
    }
}

