/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.api.WebHelper;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.ViaInstruction;
import com.graphhopper.util.shapes.GHPoint;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperWeb
implements GraphHopperAPI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OkHttpClient downloader = new OkHttpClient();
    private String serviceUrl = "https://graphhopper.com/api/1/route";
    private String key = "";
    private boolean instructions = true;
    private boolean calcPoints = true;
    private boolean elevation = false;

    public GraphHopperWeb() {
        this.downloader.setConnectTimeout(5L, TimeUnit.SECONDS);
    }

    public void setDownloader(OkHttpClient downloader) {
        this.downloader = downloader;
    }

    public OkHttpClient getDownloader() {
        return this.downloader;
    }

    public boolean load(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return true;
    }

    public GraphHopperWeb setKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalStateException("Key cannot be empty");
        }
        this.key = key;
        return this;
    }

    public GraphHopperWeb setCalcPoints(boolean calcPoints) {
        this.calcPoints = calcPoints;
        return this;
    }

    public GraphHopperWeb setInstructions(boolean b) {
        this.instructions = b;
        return this;
    }

    public GraphHopperWeb setElevation(boolean withElevation) {
        this.elevation = withElevation;
        return this;
    }

    public GHResponse route(GHRequest request) {
        StopWatch sw = new StopWatch().start();
        double took = 0.0;
        try {
            String places = "";
            for (GHPoint p : request.getPoints()) {
                places = places + "point=" + p.lat + "," + p.lon + "&";
            }
            boolean tmpInstructions = request.getHints().getBool("instructions", this.instructions);
            boolean tmpCalcPoints = request.getHints().getBool("calcPoints", this.calcPoints);
            if (tmpInstructions && !tmpCalcPoints) {
                throw new IllegalStateException("Cannot calculate instructions without points (only points without instructions). Use calcPoints=false and instructions=false to disable point and instruction calculation");
            }
            boolean tmpElevation = request.getHints().getBool("elevation", this.elevation);
            String tmpKey = request.getHints().get("key", this.key);
            String url = this.serviceUrl + "?" + places + "&type=json" + "&instructions=" + tmpInstructions + "&points_encoded=true" + "&calc_points=" + tmpCalcPoints + "&algo=" + request.getAlgorithm() + "&locale=" + request.getLocale().toString() + "&elevation=" + tmpElevation;
            if (!request.getVehicle().isEmpty()) {
                url = url + "&vehicle=" + request.getVehicle();
            }
            if (!tmpKey.isEmpty()) {
                url = url + "&key=" + tmpKey;
            }
            Request okRequest = new Request.Builder().url(url).build();
            String str = this.downloader.newCall(okRequest).execute().body().string();
            JSONObject json = new JSONObject(str);
            GHResponse res = new GHResponse();
            if (json.getJSONObject("info").has("errors")) {
                JSONArray errors = json.getJSONObject("info").getJSONArray("errors");
                for (int i = 0; i < errors.length(); ++i) {
                    JSONObject error = errors.getJSONObject(i);
                    String exClass = error.getString("details");
                    String exMessage = error.getString("message");
                    if (exClass.equals(UnsupportedOperationException.class.getName())) {
                        res.addError((Throwable)new UnsupportedOperationException(exMessage));
                        continue;
                    }
                    if (exClass.equals(IllegalStateException.class.getName())) {
                        res.addError((Throwable)new IllegalStateException(exMessage));
                        continue;
                    }
                    if (exClass.equals(RuntimeException.class.getName())) {
                        res.addError((Throwable)new RuntimeException(exMessage));
                        continue;
                    }
                    if (exClass.equals(IllegalArgumentException.class.getName())) {
                        res.addError((Throwable)new IllegalArgumentException(exMessage));
                        continue;
                    }
                    res.addError((Throwable)new Exception(exClass + " " + exMessage));
                }
                GHResponse i = res;
                return i;
            }
            took = json.getJSONObject("info").getDouble("took");
            JSONArray paths = json.getJSONArray("paths");
            JSONObject firstPath = paths.getJSONObject(0);
            double distance = firstPath.getDouble("distance");
            int time = firstPath.getInt("time");
            if (tmpCalcPoints) {
                String pointStr = firstPath.getString("points");
                PointList pointList = WebHelper.decodePolyline(pointStr, 100, tmpElevation);
                res.setPoints(pointList);
                if (tmpInstructions) {
                    JSONArray instrArr = firstPath.getJSONArray("instructions");
                    InstructionList il = new InstructionList(null);
                    int viaCount = 1;
                    for (int instrIndex = 0; instrIndex < instrArr.length(); ++instrIndex) {
                        Object instr;
                        JSONObject jsonObj = instrArr.getJSONObject(instrIndex);
                        double instDist = jsonObj.getDouble("distance");
                        String text = jsonObj.getString("text");
                        long instTime = jsonObj.getLong("time");
                        int sign = jsonObj.getInt("sign");
                        JSONArray iv = jsonObj.getJSONArray("interval");
                        int from = iv.getInt(0);
                        int to = iv.getInt(1);
                        PointList instPL = new PointList(to - from, tmpElevation);
                        for (int j = from; j <= to; ++j) {
                            instPL.add((PointAccess)pointList, j);
                        }
                        InstructionAnnotation ia = InstructionAnnotation.EMPTY;
                        if (jsonObj.has("annotation_importance") && jsonObj.has("annotation_text")) {
                            ia = new InstructionAnnotation(jsonObj.getInt("annotation_importance"), jsonObj.getString("annotation_text"));
                        }
                        if (sign == 6 || sign == -6) {
                            instr = new RoundaboutInstruction(sign, text, ia, instPL);
                        } else if (sign == 5) {
                            ViaInstruction tmpInstr = new ViaInstruction(text, ia, instPL);
                            tmpInstr.setViaCount(viaCount);
                            ++viaCount;
                            instr = tmpInstr;
                        } else {
                            instr = sign == 4 ? new FinishInstruction((PointAccess)instPL, 0) : new Instruction(sign, text, ia, instPL);
                        }
                        instr.setUseRawName();
                        instr.setDistance(instDist).setTime(instTime);
                        il.add((Instruction)instr);
                    }
                    res.setInstructions(il);
                }
            }
            GHResponse gHResponse = res.setDistance(distance).setMillis((long)time);
            return gHResponse;
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem while fetching path " + request.getPoints() + ": " + ex.getMessage(), ex);
        }
        finally {
            this.logger.debug("Full request took:" + sw.stop().getSeconds() + ", API took:" + took);
        }
    }
}

