/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.api.GHMRequest;
import com.graphhopper.api.GHMatrixAbstractRequester;
import com.graphhopper.api.GraphHopperWeb;
import com.graphhopper.api.MatrixResponse;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class GHMatrixSyncRequester
extends GHMatrixAbstractRequester {
    public GHMatrixSyncRequester() {
    }

    public GHMatrixSyncRequester(String serviceUrl) {
        super(serviceUrl);
    }

    @Override
    public MatrixResponse route(GHMRequest ghRequest, String key) {
        String pointsStr;
        int fromCount;
        int toCount;
        StopWatch sw = new StopWatch().start();
        if (ghRequest.identicalLists) {
            fromCount = toCount = ghRequest.getFromPoints().size();
            pointsStr = this.createPointQuery(ghRequest.getFromPoints(), "point");
        } else {
            fromCount = ghRequest.getFromPoints().size();
            toCount = ghRequest.getToPoints().size();
            pointsStr = this.createPointQuery(ghRequest.getFromPoints(), "from_point");
            pointsStr = pointsStr + "&" + this.createPointQuery(ghRequest.getToPoints(), "to_point");
        }
        String outArrayStr = "";
        ArrayList<String> outArraysList = new ArrayList<String>(ghRequest.getOutArrays());
        if (outArraysList.isEmpty()) {
            outArraysList.add("weights");
        }
        for (String type : outArraysList) {
            if (!type.isEmpty()) {
                outArrayStr = outArrayStr + "&";
            }
            outArrayStr = outArrayStr + "out_array=" + type;
        }
        boolean hasElevation = false;
        String url = this.serviceUrl + "?" + pointsStr + "&" + outArrayStr + "&vehicle=" + ghRequest.getVehicle() + "&key=" + key;
        MatrixResponse matrixResponse = new MatrixResponse(ghRequest.getFromPoints().size(), ghRequest.getToPoints().size());
        try {
            String str = this.getJson(url);
            JSONObject getResponseJson = null;
            try {
                getResponseJson = new JSONObject(str);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot parse json " + str + " from " + url);
            }
            matrixResponse.addErrors(GraphHopperWeb.readErrors(getResponseJson));
            if (!matrixResponse.hasErrors()) {
                this.fillResponseFromJson(ghRequest, outArraysList, matrixResponse, getResponseJson, hasElevation);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return matrixResponse;
    }

    private String createPointQuery(List<GHPoint> list, String pointName) {
        String pointsStr = "";
        for (GHPoint p : list) {
            if (!pointsStr.isEmpty()) {
                pointsStr = pointsStr + "&";
            }
            pointsStr = pointsStr + pointName + "=" + this.encode(p.lat + "," + p.lon);
        }
        return pointsStr;
    }

    public String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception ex) {
            return str;
        }
    }
}

