/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.api.GHMRequest;
import com.graphhopper.api.GHMatrixAbstractRequester;
import com.graphhopper.api.MatrixResponse;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.GHPoint;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class GoogleMatrixSyncRequester
extends GHMatrixAbstractRequester {
    private final Set<String> ignoreSet = new HashSet<String>(10);

    public GoogleMatrixSyncRequester() {
    }

    public GoogleMatrixSyncRequester(String serviceUrl) {
        super(serviceUrl);
        this.ignoreSet.add("mode");
        this.ignoreSet.add("key");
        this.ignoreSet.add("units");
        this.ignoreSet.add("destinations");
        this.ignoreSet.add("origins");
        this.ignoreSet.add("mode");
    }

    @Override
    public MatrixResponse route(GHMRequest ghRequest, String key) {
        String tmpServiceURL;
        String url;
        String pointsStr = this.createGoogleQuery(ghRequest.getFromPoints(), "origins");
        pointsStr = pointsStr + "&" + this.createGoogleQuery(ghRequest.getToPoints(), "destinations");
        ArrayList<String> outArraysList = new ArrayList<String>(ghRequest.getOutArrays());
        if (outArraysList.isEmpty()) {
            outArraysList.add("distances");
            outArraysList.add("times");
        }
        if (!(url = (tmpServiceURL = ghRequest.getHints().get("service_url", this.serviceUrl))).contains("?")) {
            url = url + "?";
        }
        url = url + pointsStr + "&mode=" + ghRequest.getVehicle();
        if (!Helper.isEmpty((String)key)) {
            url = url + "&key=" + key;
        }
        for (Map.Entry entry : ghRequest.getHints().toMap().entrySet()) {
            if (this.ignoreSet.contains(entry.getKey())) continue;
            url = url + "&" + (String)entry.getKey() + "=" + this.encode((String)entry.getValue());
        }
        boolean withTimes = outArraysList.contains("times");
        boolean withDistances = outArraysList.contains("distances");
        boolean withWeights = outArraysList.contains("weights");
        if (withWeights) {
            throw new UnsupportedOperationException("Google Matrix API does not include weights");
        }
        MatrixResponse matrixResponse = new MatrixResponse(ghRequest.getFromPoints().size(), ghRequest.getToPoints().size(), withTimes, withDistances, false);
        try {
            String str = this.getJson(url);
            JSONObject getResponseJson = null;
            try {
                getResponseJson = new JSONObject(str);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot parse json " + str + " from " + url);
            }
            this.fillResponseFromGoogleJson(matrixResponse, getResponseJson);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return matrixResponse;
    }

    private String createGoogleQuery(List<GHPoint> list, String pointName) {
        String pointsStr = "";
        for (GHPoint p : list) {
            if (!pointsStr.isEmpty()) {
                pointsStr = pointsStr + "|";
            }
            pointsStr = pointsStr + this.encode(p.lat + "," + p.lon);
        }
        return pointName + "=" + pointsStr;
    }

    public String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception ex) {
            return str;
        }
    }

    private void fillResponseFromGoogleJson(MatrixResponse matrixResponse, JSONObject responseJson) {
        JSONArray rows = responseJson.getJSONArray("rows");
        int fromCount = rows.length();
        for (int fromIndex = 0; fromIndex < fromCount; ++fromIndex) {
            JSONObject elementsObj = rows.getJSONObject(fromIndex);
            JSONArray elements = elementsObj.getJSONArray("elements");
            int toCount = elements.length();
            long[] times = new long[toCount];
            int[] distances = new int[toCount];
            for (int toIndex = 0; toIndex < toCount; ++toIndex) {
                JSONObject element = elements.getJSONObject(toIndex);
                if ("OK".equals(element.getString("status"))) {
                    JSONObject distance = element.getJSONObject("distance");
                    JSONObject duration = element.getJSONObject("duration");
                    times[toIndex] = duration.getInt("value") * 1000;
                    distances[toIndex] = Math.round(distance.getInt("value"));
                    continue;
                }
                matrixResponse.addError(new IllegalArgumentException("Cannot find route " + fromIndex + "->" + toIndex));
            }
            matrixResponse.setTimeRow(fromIndex, times);
            matrixResponse.setDistanceRow(fromIndex, distances);
        }
    }
}

