/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MatrixResponse {
    private String debugInfo = "";
    private final List<Throwable> errors = new ArrayList<Throwable>(4);
    private long[][] times = new long[0][];
    private int[][] distances = new int[0][];
    private double[][] weights = new double[0][];

    public MatrixResponse() {
        this(10, 10, true, true, true);
    }

    public MatrixResponse(int fromCap, int toCap, boolean withTimes, boolean withDistances, boolean withWeights) {
        if (withTimes) {
            this.times = new long[fromCap][toCap];
        }
        if (withDistances) {
            this.distances = new int[fromCap][toCap];
        }
        if (withWeights) {
            this.weights = new double[fromCap][toCap];
        }
    }

    public void setFromRow(int row, long[] timeRow, int[] distanceRow, double[] weightRow) {
        if (this.times.length > 0) {
            this.times[row] = timeRow;
        }
        if (this.distances.length > 0) {
            this.distances[row] = distanceRow;
        }
        if (this.weights.length > 0) {
            this.weights[row] = weightRow;
        }
    }

    public void setTimeRow(int row, long[] timeRow) {
        if (this.times.length <= 0) {
            throw new UnsupportedOperationException("Cannot call setTimeRow if times are disabled");
        }
        this.times[row] = timeRow;
    }

    public void setDistanceRow(int row, int[] distanceRow) {
        if (this.distances.length <= 0) {
            throw new UnsupportedOperationException("Cannot call setDistanceRow if distances are disabled");
        }
        this.distances[row] = distanceRow;
    }

    public void setWeightRow(int row, double[] weightRow) {
        if (this.weights.length <= 0) {
            throw new UnsupportedOperationException("Cannot call setWeightRow if weights are disabled");
        }
        this.weights[row] = weightRow;
    }

    public long getTime(int from, int to) {
        if (this.hasErrors()) {
            throw new IllegalStateException("Cannot return time (" + from + "," + to + ") if errors occured " + this.getErrors());
        }
        if (from >= this.times.length) {
            throw new IllegalStateException("Cannot get 'from' " + from + " from times with size " + this.times.length);
        }
        if (to >= this.times[from].length) {
            throw new IllegalStateException("Cannot get 'to' " + to + " from times with size " + this.times[from].length);
        }
        return this.times[from][to];
    }

    public double getDistance(int from, int to) {
        if (this.hasErrors()) {
            throw new IllegalStateException("Cannot return distance (" + from + "," + to + ") if errors occured " + this.getErrors());
        }
        if (from >= this.distances.length) {
            throw new IllegalStateException("Cannot get 'from' " + from + " from distances with size " + this.distances.length);
        }
        if (to >= this.distances[from].length) {
            throw new IllegalStateException("Cannot get 'to' " + to + " from distances with size " + this.distances[from].length);
        }
        return this.distances[from][to];
    }

    public double getWeight(int from, int to) {
        if (this.hasErrors()) {
            throw new IllegalStateException("Cannot return weight (" + from + "," + to + ") if errors occured " + this.getErrors());
        }
        if (from >= this.weights.length) {
            throw new IllegalStateException("Cannot get 'from' " + from + " from weights with size " + this.weights.length);
        }
        if (to >= this.weights[from].length) {
            throw new IllegalStateException("Cannot get 'to' " + to + " from weights with size " + this.weights[from].length);
        }
        return this.weights[from][to];
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public MatrixResponse setDebugInfo(String debugInfo) {
        if (debugInfo != null) {
            this.debugInfo = debugInfo;
        }
        return this;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public MatrixResponse addError(Throwable error) {
        this.errors.add(error);
        return this;
    }

    public MatrixResponse addErrors(Collection<Throwable> errorList) {
        this.errors.addAll(errorList);
        return this;
    }

    public String toString() {
        String addInfo = "";
        if (this.times.length > 0) {
            addInfo = addInfo + ", times: " + this.times.length + "x" + this.times[0].length;
        }
        if (this.distances.length > 0) {
            addInfo = addInfo + ", distances: " + this.distances.length + "x" + this.distances[0].length;
        }
        return "[" + addInfo + "] errors:" + this.errors.toString();
    }
}

