/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import java.net.URLEncoder;
import org.json.JSONArray;

public class WebHelper {
    public static String encodeURL(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception _ignore) {
            return str;
        }
    }

    public static PointList decodePolyline(String encoded, int initCap, boolean is3D) {
        PointList poly = new PointList(initCap, is3D);
        int index = 0;
        int len = encoded.length();
        int lat = 0;
        int lng = 0;
        int ele = 0;
        while (index < len) {
            int b;
            int shift = 0;
            int result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int deltaLatitude = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lat += deltaLatitude;
            shift = 0;
            result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int deltaLongitude = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lng += deltaLongitude;
            if (is3D) {
                shift = 0;
                result = 0;
                do {
                    b = encoded.charAt(index++) - 63;
                    result |= (b & 0x1F) << shift;
                    shift += 5;
                } while (b >= 32);
                int deltaElevation = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
                poly.add((double)lat / 100000.0, (double)lng / 100000.0, (double)(ele += deltaElevation) / 100.0);
                continue;
            }
            poly.add((double)lat / 100000.0, (double)lng / 100000.0);
        }
        return poly;
    }

    public static GHPoint toGHPoint(JSONArray point) {
        if (point.length() == 3 && !Double.isNaN(point.getDouble(2))) {
            return new GHPoint3D(point.getDouble(1), point.getDouble(0), point.getDouble(2));
        }
        return new GHPoint(point.getDouble(1), point.getDouble(0));
    }
}

