/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.servlet.SubscriptionConnectionListener;
import graphql.servlet.SubscriptionException;
import java.time.Duration;
import java.util.Optional;

public interface ApolloSubscriptionConnectionListener
extends SubscriptionConnectionListener {
    public static final long KEEP_ALIVE_INTERVAL_SEC = 15L;
    public static final String CONNECT_RESULT_KEY = "CONNECT_RESULT";

    default public boolean isKeepAliveEnabled() {
        return true;
    }

    default public Optional<Object> onConnect(Object payload) throws SubscriptionException {
        return Optional.empty();
    }

    default public Duration getKeepAliveInterval() {
        return Duration.ofSeconds(15L);
    }

    public static ApolloSubscriptionConnectionListener createWithKeepAliveDisabled() {
        return new ApolloSubscriptionConnectionListener(){

            @Override
            public boolean isKeepAliveEnabled() {
                return false;
            }
        };
    }

    public static ApolloSubscriptionConnectionListener createWithKeepAliveInterval(final Duration interval) {
        return new ApolloSubscriptionConnectionListener(){

            @Override
            public Duration getKeepAliveInterval() {
                return interval;
            }
        };
    }
}

