/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.GraphQLException;
import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.GraphQLQueryResult;
import graphql.kickstart.execution.input.GraphQLBatchedInvocationInput;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.GraphQLInvocationInputParser;
import graphql.kickstart.servlet.HttpRequestHandler;
import graphql.kickstart.servlet.QueryResponseWriter;
import graphql.kickstart.servlet.input.BatchInputPreProcessResult;
import graphql.kickstart.servlet.input.BatchInputPreProcessor;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpRequestHandlerImpl
implements HttpRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHandlerImpl.class);
    private final GraphQLConfiguration configuration;
    private final GraphQLInvoker graphQLInvoker;

    HttpRequestHandlerImpl(GraphQLConfiguration configuration) {
        this.configuration = configuration;
        this.graphQLInvoker = configuration.getGraphQLInvoker();
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            GraphQLInvocationInputParser invocationInputParser = GraphQLInvocationInputParser.create(request, this.configuration.getInvocationInputFactory(), this.configuration.getObjectMapper(), this.configuration.getContextSetting());
            GraphQLInvocationInput invocationInput = invocationInputParser.getGraphQLInvocationInput(request, response);
            this.execute(invocationInput, request, response);
        }
        catch (GraphQLException e) {
            response.setStatus(400);
            log.info("Bad request: cannot create invocation input parser", (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            response.setStatus(500);
            log.info("Bad request: cannot create invocation input parser", t);
            throw t;
        }
    }

    private void execute(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response) {
        try {
            GraphQLQueryResult queryResult = this.invoke(invocationInput, request, response);
            QueryResponseWriter queryResponseWriter = QueryResponseWriter.createWriter(queryResult, this.configuration.getObjectMapper(), this.configuration.getSubscriptionTimeout());
            queryResponseWriter.write(request, response);
        }
        catch (Throwable t) {
            response.setStatus(400);
            log.info("Bad GET request: path was not \"/schema.json\" or no query variable named \"query\" given");
            log.debug("Possibly due to exception: ", t);
        }
    }

    private GraphQLQueryResult invoke(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response) {
        if (invocationInput instanceof GraphQLSingleInvocationInput) {
            return this.graphQLInvoker.query(invocationInput);
        }
        return this.invokeBatched((GraphQLBatchedInvocationInput)invocationInput, request, response);
    }

    private GraphQLQueryResult invokeBatched(GraphQLBatchedInvocationInput batchedInvocationInput, HttpServletRequest request, HttpServletResponse response) {
        BatchInputPreProcessor preprocessor = this.configuration.getBatchInputPreProcessor();
        BatchInputPreProcessResult result = preprocessor.preProcessBatch(batchedInvocationInput, request, response);
        if (result.isExecutable()) {
            return this.graphQLInvoker.query((GraphQLInvocationInput)result.getBatchedInvocationInput());
        }
        return GraphQLQueryResult.createError((int)result.getStatusCode(), (String)result.getStatusMessage());
    }
}

