/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.ExecutionResult;
import graphql.execution.ExecutionContext;
import graphql.execution.SimpleExecutionStrategy;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.VariableReference;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedExecutionStrategy
extends SimpleExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(EnhancedExecutionStrategy.class);
    private static final String CLIENT_MUTATION_ID = "clientMutationId";

    protected ExecutionResult resolveField(ExecutionContext executionContext, GraphQLObjectType parentType, Object source, List<Field> fields) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, fields.get(0));
        if (fieldDef == null) {
            return null;
        }
        if (fieldDef.getName().contentEquals(CLIENT_MUTATION_ID)) {
            Object clientMutationId;
            Field field = (Field)executionContext.getOperationDefinition().getSelectionSet().getSelections().get(0);
            Argument argument = (Argument)field.getArguments().get(0);
            if (argument.getValue() instanceof VariableReference) {
                VariableReference ref = (VariableReference)argument.getValue();
                HashMap mutationInputVariables = (HashMap)executionContext.getVariables().get(ref.getName());
                clientMutationId = mutationInputVariables.get(CLIENT_MUTATION_ID);
            } else {
                ObjectValue value = (ObjectValue)((Argument)field.getArguments().get(0)).getValue();
                StringValue clientMutationIdVal = (StringValue)value.getObjectFields().stream().filter(f -> f.getName().contentEquals(CLIENT_MUTATION_ID)).findFirst().get().getValue();
                clientMutationId = clientMutationIdVal.getValue();
            }
            return this.completeValue(executionContext, (GraphQLType)fieldDef.getType(), fields, clientMutationId);
        }
        return super.resolveField(executionContext, parentType, source, fields);
    }

    protected ExecutionResult completeValue(ExecutionContext executionContext, GraphQLType fieldType, List<Field> fields, Object result) {
        if (result instanceof Enum && fieldType instanceof GraphQLEnumType) {
            return super.completeValue(executionContext, fieldType, fields, ((GraphQLEnumType)fieldType).getCoercing().parseValue((Object)((Enum)result).name()));
        }
        if (result instanceof Optional) {
            return this.completeValue(executionContext, fieldType, fields, ((Optional)result).orElse(null));
        }
        return super.completeValue(executionContext, fieldType, fields, result);
    }
}

