/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLException;
import graphql.PublicApi;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionParameters;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SimpleExecutionStrategy;
import graphql.language.Field;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@PublicApi
public class ExecutorServiceExecutionStrategy
extends ExecutionStrategy {
    ExecutorService executorService;

    public ExecutorServiceExecutionStrategy(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public ExecutionResult execute(ExecutionContext executionContext, ExecutionParameters parameters) {
        if (this.executorService == null) {
            return new SimpleExecutionStrategy().execute(executionContext, parameters);
        }
        Map<String, List<Field>> fields = parameters.fields();
        LinkedHashMap<String, Future<ExecutionResult>> futures = new LinkedHashMap<String, Future<ExecutionResult>>();
        for (String fieldName : fields.keySet()) {
            List<Field> fieldList = fields.get(fieldName);
            Callable<ExecutionResult> resolveField = () -> this.resolveField(executionContext, parameters, fieldList);
            futures.put(fieldName, this.executorService.submit(resolveField));
        }
        try {
            LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
            Iterator iterator = futures.keySet().iterator();
            while (iterator.hasNext()) {
                String fieldName;
                ExecutionResult executionResult = (ExecutionResult)((Future)futures.get(fieldName = (String)iterator.next())).get();
                results.put(fieldName, executionResult != null ? executionResult.getData() : null);
            }
            return new ExecutionResultImpl(results, executionContext.getErrors());
        }
        catch (InterruptedException e) {
            throw new GraphQLException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new GraphQLException((Throwable)e);
        }
    }
}

