/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.PublicApi;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import java.util.Objects;
import java.util.StringJoiner;

@PublicApi
public class ValidationCoordinates {
    private final String containerType;
    private final String fieldName;
    private final String argName;

    public ValidationCoordinates(String containerType, String fieldName, String argName) {
        this.containerType = Objects.requireNonNull(containerType);
        this.fieldName = Objects.requireNonNull(fieldName);
        this.argName = argName;
    }

    public static ValidationCoordinates newCoordinates(GraphQLFieldsContainer fieldsContainer, GraphQLFieldDefinition fieldDefinition, GraphQLArgument fieldArg) {
        return new ValidationCoordinates(fieldsContainer.getName(), fieldDefinition.getName(), fieldArg.getName());
    }

    public static ValidationCoordinates newCoordinates(GraphQLFieldsContainer fieldsContainer, GraphQLFieldDefinition fieldDefinition) {
        return new ValidationCoordinates(fieldsContainer.getName(), fieldDefinition.getName(), null);
    }

    public static ValidationCoordinates newCoordinates(String fieldsContainer, String fieldDefinition, String fieldArg) {
        return new ValidationCoordinates(fieldsContainer, fieldDefinition, fieldArg);
    }

    public static ValidationCoordinates newCoordinates(String fieldsContainer, String fieldDefinition) {
        return new ValidationCoordinates(fieldsContainer, fieldDefinition, null);
    }

    public String getContainerType() {
        return this.containerType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getArgName() {
        return this.argName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationCoordinates that = (ValidationCoordinates)o;
        return Objects.equals(this.containerType, that.containerType) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.argName, that.argName);
    }

    public int hashCode() {
        return Objects.hash(this.containerType, this.fieldName, this.argName);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("containerType=" + this.getContainerType()).add("fieldName=" + this.getFieldName()).add("argName=" + this.getArgName()).toString();
    }
}

