/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.GraphQLException;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionContextBuilder;
import graphql.execution.ExecutionStrategy;
import graphql.execution.FieldCollector;
import graphql.execution.SimpleExecutionStrategy;
import graphql.execution.ValuesResolver;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Execution {
    private FieldCollector fieldCollector = new FieldCollector();
    private ExecutionStrategy strategy;

    public Execution(ExecutionStrategy strategy) {
        this.strategy = strategy;
        if (this.strategy == null) {
            this.strategy = new SimpleExecutionStrategy();
        }
    }

    public ExecutionResult execute(GraphQLSchema graphQLSchema, Object root, Document document, String operationName, Map<String, Object> args) {
        ExecutionContextBuilder executionContextBuilder = new ExecutionContextBuilder(new ValuesResolver());
        ExecutionContext executionContext = executionContextBuilder.build(graphQLSchema, this.strategy, root, document, operationName, args);
        return this.executeOperation(executionContext, root, executionContext.getOperationDefinition());
    }

    private GraphQLObjectType getOperationRootType(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition) {
        if (operationDefinition.getOperation() == OperationDefinition.Operation.MUTATION) {
            return graphQLSchema.getMutationType();
        }
        if (operationDefinition.getOperation() == OperationDefinition.Operation.QUERY) {
            return graphQLSchema.getQueryType();
        }
        throw new GraphQLException();
    }

    private ExecutionResult executeOperation(ExecutionContext executionContext, Object root, OperationDefinition operationDefinition) {
        GraphQLObjectType operationRootType = this.getOperationRootType(executionContext.getGraphQLSchema(), operationDefinition);
        LinkedHashMap<String, List<Field>> fields = new LinkedHashMap<String, List<Field>>();
        this.fieldCollector.collectFields(executionContext, operationRootType, operationDefinition.getSelectionSet(), new ArrayList<String>(), fields);
        if (operationDefinition.getOperation() == OperationDefinition.Operation.MUTATION) {
            return new SimpleExecutionStrategy().execute(executionContext, operationRootType, root, fields);
        }
        return this.strategy.execute(executionContext, operationRootType, root, fields);
    }
}

