/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.schema.GraphQLInputType;

public class GraphQLArgument {
    private final String name;
    private final String description;
    private GraphQLInputType type;
    private final Object defaultValue;

    public GraphQLArgument(String name, String description, GraphQLInputType type, Object defaultValue) {
        Assert.assertNotNull(name, "name can't be null");
        Assert.assertNotNull(type, "type can't be null");
        this.name = name;
        this.description = description;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public GraphQLArgument(String name, GraphQLInputType type) {
        this(name, null, type, null);
    }

    public String getName() {
        return this.name;
    }

    public GraphQLInputType getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public static Builder newArgument() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private GraphQLInputType type;
        private Object defaultValue;
        private String description;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder type(GraphQLInputType type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public GraphQLArgument build() {
            return new GraphQLArgument(this.name, this.description, this.type, this.defaultValue);
        }
    }
}

