/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.schema.BuilderFunction;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GraphQLInputObjectType
implements GraphQLType,
GraphQLInputType,
GraphQLUnmodifiedType,
GraphQLNullableType {
    private final String name;
    private final String description;
    private final Map<String, GraphQLInputObjectField> fieldMap = new LinkedHashMap<String, GraphQLInputObjectField>();

    public GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields) {
        Assert.assertNotNull(name, "name can't be null");
        Assert.assertNotNull(fields, "fields can't be null");
        this.name = name;
        this.description = description;
        this.buildMap(fields);
    }

    private void buildMap(List<GraphQLInputObjectField> fields) {
        for (GraphQLInputObjectField field : fields) {
            String name = field.getName();
            if (this.fieldMap.containsKey(name)) {
                throw new AssertException("field " + name + " redefined");
            }
            this.fieldMap.put(name, field);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<GraphQLInputObjectField> getFields() {
        return new ArrayList<GraphQLInputObjectField>(this.fieldMap.values());
    }

    public GraphQLInputObjectField getField(String name) {
        return this.fieldMap.get(name);
    }

    public static Builder newInputObject() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private List<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder field(GraphQLInputObjectField field) {
            Assert.assertNotNull(field, "field can't be null");
            this.fields.add(field);
            return this;
        }

        public Builder field(BuilderFunction<GraphQLInputObjectField.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, "builderFunction should not be null");
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField();
            builder = builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLInputObjectField.Builder builder) {
            this.fields.add(builder.build());
            return this;
        }

        public Builder fields(List<GraphQLInputObjectField> fields) {
            for (GraphQLInputObjectField field : fields) {
                this.field(field);
            }
            return this;
        }

        public GraphQLInputObjectType build() {
            return new GraphQLInputObjectType(this.name, this.description, this.fields);
        }
    }
}

