/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.schema.BuilderFunction;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.TypeResolver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GraphQLInterfaceType
implements GraphQLType,
GraphQLOutputType,
GraphQLFieldsContainer,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType {
    private final String name;
    private final String description;
    private final Map<String, GraphQLFieldDefinition> fieldDefinitionsByName = new LinkedHashMap<String, GraphQLFieldDefinition>();
    private final TypeResolver typeResolver;

    public GraphQLInterfaceType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, TypeResolver typeResolver) {
        Assert.assertNotNull(name, "name can't null");
        Assert.assertNotNull(typeResolver, "typeResolver can't null");
        Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't null");
        this.name = name;
        this.description = description;
        this.buildDefinitionMap(fieldDefinitions);
        this.typeResolver = typeResolver;
    }

    private void buildDefinitionMap(List<GraphQLFieldDefinition> fieldDefinitions) {
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            String name = fieldDefinition.getName();
            if (this.fieldDefinitionsByName.containsKey(name)) {
                throw new AssertException("field " + name + " redefined");
            }
            this.fieldDefinitionsByName.put(name, fieldDefinition);
        }
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(String name) {
        return this.fieldDefinitionsByName.get(name);
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions() {
        return new ArrayList<GraphQLFieldDefinition>(this.fieldDefinitionsByName.values());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public String toString() {
        return "GraphQLInterfaceType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fieldDefinitionsByName=" + this.fieldDefinitionsByName + ", typeResolver=" + this.typeResolver + '}';
    }

    public static Builder newInterface() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private List<GraphQLFieldDefinition> fields = new ArrayList<GraphQLFieldDefinition>();
        private TypeResolver typeResolver;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder field(GraphQLFieldDefinition fieldDefinition) {
            this.fields.add(fieldDefinition);
            return this;
        }

        public Builder field(BuilderFunction<GraphQLFieldDefinition.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, "builderFunction can't be null");
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            builder = builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLFieldDefinition.Builder builder) {
            this.fields.add(builder.build());
            return this;
        }

        public Builder fields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't be null");
            this.fields.addAll(fieldDefinitions);
            return this;
        }

        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public GraphQLInterfaceType build() {
            return new GraphQLInterfaceType(this.name, this.description, this.fields, this.typeResolver);
        }
    }
}

