/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.io.CharStreams;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLSchema;
import graphql.servlet.GenericGraphQLError;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLMBean;
import graphql.servlet.GraphQLOperationListener;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServletListener;
import graphql.validation.ValidationError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphQLServlet
extends HttpServlet
implements Servlet,
GraphQLMBean,
GraphQLSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(GraphQLServlet.class);
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final int STATUS_OK = 200;
    public static final int STATUS_BAD_REQUEST = 400;
    private static final ObjectMapper mapper = new ObjectMapper();
    private final List<GraphQLOperationListener> operationListeners;
    private final List<GraphQLServletListener> servletListeners;
    private final ServletFileUpload fileUpload;
    private final RequestHandler getHandler;
    private final RequestHandler postHandler;

    protected abstract GraphQLContext createContext(Optional<HttpServletRequest> var1, Optional<HttpServletResponse> var2);

    protected abstract ExecutionStrategy getExecutionStrategy();

    protected abstract Map<String, Object> transformVariables(GraphQLSchema var1, String var2, Map<String, Object> var3);

    public GraphQLServlet() {
        this(null, null, null);
    }

    public GraphQLServlet(List<GraphQLOperationListener> operationListeners, List<GraphQLServletListener> servletListeners, FileItemFactory fileItemFactory) {
        this.operationListeners = operationListeners != null ? new ArrayList<GraphQLOperationListener>(operationListeners) : new ArrayList();
        this.servletListeners = servletListeners != null ? new ArrayList<GraphQLServletListener>(servletListeners) : new ArrayList();
        this.fileUpload = new ServletFileUpload((FileItemFactory)(fileItemFactory != null ? fileItemFactory : new DiskFileItemFactory()));
        this.getHandler = (request, response) -> {
            GraphQLContext context = this.createContext(Optional.of(request), Optional.of(response));
            String path = request.getPathInfo();
            if (path == null) {
                path = request.getServletPath();
            }
            if (path.contentEquals("/schema.json")) {
                this.query(CharStreams.toString((Readable)new InputStreamReader(GraphQLServlet.class.getResourceAsStream("introspectionQuery"))), null, new HashMap<String, Object>(), this.getSchema(), request, response, context);
            } else if (request.getParameter("query") != null) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                if (request.getParameter("variables") != null) {
                    variables.putAll((Map)mapper.readValue(request.getParameter("variables"), (TypeReference)new TypeReference<Map<String, Object>>(){}));
                }
                String operationName = null;
                if (request.getParameter("operationName") != null) {
                    operationName = request.getParameter("operationName");
                }
                this.query(request.getParameter("query"), operationName, variables, this.getReadOnlySchema(), request, response, context);
            } else {
                response.setStatus(400);
                log.info("Bad GET request: path was not \"/schema.json\" or no query variable named \"query\" given");
            }
        };
        this.postHandler = (request, response) -> {
            GraphQLContext context = this.createContext(Optional.of(request), Optional.of(response));
            GraphQLRequest graphQLRequest = null;
            try {
                Object inputStream = null;
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    Optional<FileItem> queryItem;
                    Map fileItems = this.fileUpload.parseParameterMap(request);
                    if (fileItems.containsKey("graphql")) {
                        Optional<FileItem> graphqlItem = this.getFileItem(fileItems, "graphql");
                        if (graphqlItem.isPresent()) {
                            inputStream = graphqlItem.get().getInputStream();
                        }
                    } else if (fileItems.containsKey("query") && (queryItem = this.getFileItem(fileItems, "query")).isPresent()) {
                        String variables;
                        Optional<FileItem> variablesItem;
                        graphQLRequest = new GraphQLRequest();
                        graphQLRequest.setQuery(new String(queryItem.get().get()));
                        Optional<FileItem> operationNameItem = this.getFileItem(fileItems, "operationName");
                        if (operationNameItem.isPresent()) {
                            graphQLRequest.setOperationName(new String(operationNameItem.get().get()).trim());
                        }
                        if ((variablesItem = this.getFileItem(fileItems, "variables")).isPresent() && !(variables = new String(variablesItem.get().get())).isEmpty()) {
                            graphQLRequest.setVariables((Map)mapper.readValue(variables, Map.class));
                        }
                    }
                    if (inputStream == null && graphQLRequest == null) {
                        response.setStatus(400);
                        log.info("Bad POST multipart request: no part named \"graphql\" or \"query\"");
                        return;
                    }
                    context.setFiles(Optional.of(fileItems));
                } else {
                    inputStream = request.getInputStream();
                }
                if (graphQLRequest == null) {
                    graphQLRequest = (GraphQLRequest)mapper.readValue((InputStream)inputStream, GraphQLRequest.class);
                }
            }
            catch (Exception e) {
                log.info("Bad POST request: parsing failed", (Throwable)e);
                response.setStatus(400);
                return;
            }
            Map<String, Object> variables = graphQLRequest.getVariables();
            if (variables == null) {
                variables = new HashMap<String, Object>();
            }
            this.query(graphQLRequest.getQuery(), graphQLRequest.getOperationName(), variables, this.getSchema(), request, response, context);
        };
    }

    public void addOperationListener(GraphQLOperationListener operationListener) {
        this.operationListeners.add(operationListener);
    }

    public void removeOperationListener(GraphQLOperationListener operationListener) {
        this.operationListeners.remove(operationListener);
    }

    public void addServletListener(GraphQLServletListener servletListener) {
        this.servletListeners.add(servletListener);
    }

    public void removeServletListener(GraphQLServletListener servletListener) {
        this.servletListeners.remove(servletListener);
    }

    @Override
    public String[] getQueries() {
        return (String[])this.getSchema().getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.getSchema().getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String executeQuery(String query) {
        try {
            ExecutionResult result = new GraphQL(this.getSchema()).execute(query, (Object)this.createContext(Optional.empty(), Optional.empty()), new HashMap());
            return mapper.writeValueAsString(this.createResultFromDataAndErrors(result.getData(), result.getErrors()));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(HttpServletRequest request, HttpServletResponse response, RequestHandler handler) {
        try {
            this.runListeners(this.servletListeners, l -> l.onStart(request, response));
            handler.handle(request, response);
        }
        catch (Throwable t) {
            response.setStatus(500);
            log.error("Error executing GraphQL request!", t);
            this.runListeners(this.servletListeners, l -> l.onError(request, response, t));
        }
        finally {
            this.runListeners(this.servletListeners, l -> l.onFinally(request, response));
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp, this.getHandler);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp, this.postHandler);
    }

    private Optional<FileItem> getFileItem(Map<String, List<FileItem>> fileItems, String name) {
        List<FileItem> items = fileItems.get(name);
        if (items == null || items.isEmpty()) {
            return Optional.empty();
        }
        return items.stream().findFirst();
    }

    private void query(final String query, final String operationName, final Map<String, Object> variables, final GraphQLSchema schema, final HttpServletRequest req, final HttpServletResponse resp, final GraphQLContext context) throws IOException {
        if (Subject.getSubject(AccessController.getContext()) == null && context.getSubject().isPresent()) {
            Subject.doAs(context.getSubject().get(), new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    GraphQLServlet.this.query(query, operationName, variables, schema, req, resp, context);
                    return null;
                }
            });
        } else {
            this.runListeners(this.operationListeners, l -> this.runListener(l, it -> it.beforeGraphQLOperation(context, operationName, query, variables)));
            ExecutionResult executionResult = new GraphQL(schema, this.getExecutionStrategy()).execute(query, operationName, (Object)context, this.transformVariables(schema, query, variables));
            List errors = executionResult.getErrors();
            Object data = executionResult.getData();
            String response = mapper.writeValueAsString(this.createResultFromDataAndErrors(data, errors));
            resp.setContentType(APPLICATION_JSON_UTF8);
            resp.setStatus(200);
            resp.getWriter().write(response);
            if (this.errorsPresent(errors)) {
                this.runListeners(this.operationListeners, l -> l.onFailedGraphQLOperation(context, operationName, query, variables, data, errors));
            } else {
                this.runListeners(this.operationListeners, l -> l.onSuccessfulGraphQLOperation(context, operationName, query, variables, data));
            }
        }
    }

    private Map<String, Object> createResultFromDataAndErrors(Object data, List<GraphQLError> errors) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", data);
        if (this.errorsPresent(errors)) {
            List<GraphQLError> clientErrors = this.filterGraphQLErrors(errors);
            if (clientErrors.size() < errors.size()) {
                clientErrors.add(new GenericGraphQLError("Internal Server Error(s) while executing query"));
            }
            result.put("errors", clientErrors);
        }
        return result;
    }

    private boolean errorsPresent(List<GraphQLError> errors) {
        return errors != null && !errors.isEmpty();
    }

    protected List<GraphQLError> filterGraphQLErrors(List<GraphQLError> errors) {
        return errors.stream().filter(error -> error instanceof InvalidSyntaxError || error instanceof ValidationError).collect(Collectors.toList());
    }

    private <T> void runListeners(List<T> listeners, Consumer<? super T> action) {
        if (listeners != null) {
            listeners.forEach(l -> this.runListener(l, action));
        }
    }

    private <T> void runListener(T listener, Consumer<? super T> action) {
        try {
            action.accept(listener);
        }
        catch (Throwable t) {
            log.error("Error running listener: {}", (Object)listener.getClass().getName(), (Object)t);
        }
    }

    protected static interface RequestHandler
    extends BiConsumer<HttpServletRequest, HttpServletResponse> {
        @Override
        default public void accept(HttpServletRequest request, HttpServletResponse response) {
            try {
                this.handle(request, response);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void handle(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
    }

    protected static class GraphQLRequest {
        private String query;
        @JsonDeserialize(using=VariablesDeserializer.class)
        private Map<String, Object> variables = new HashMap<String, Object>();
        private String operationName;

        protected GraphQLRequest() {
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }
    }

    protected static class VariablesDeserializer
    extends JsonDeserializer<Map<String, Object>> {
        protected VariablesDeserializer() {
        }

        public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object o = p.readValueAs(Object.class);
            if (o instanceof Map) {
                return (Map)o;
            }
            if (o instanceof String) {
                return (Map)mapper.readValue((String)o, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            throw new RuntimeJsonMappingException("variables should be either an object or a string");
        }
    }
}

