/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.GraphQLError;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class RxExecutionResult
implements ExecutionResult {
    private static final Logger logger = LoggerFactory.getLogger(RxExecutionResult.class);
    private Observable<?> dataObservable;
    private Observable<List<GraphQLError>> errorsObservable;

    public RxExecutionResult(Observable<?> data, Observable<List<GraphQLError>> errors) {
        this.dataObservable = data;
        this.errorsObservable = errors;
    }

    public Observable<?> getDataObservable() {
        return this.dataObservable;
    }

    public Observable<List<GraphQLError>> getErrorsObservable() {
        return this.errorsObservable;
    }

    public Object getData() {
        logger.warn("getData() called instead of getDataObservable(), blocking (likely a bug)");
        return this.dataObservable.toBlocking().first();
    }

    public List<GraphQLError> getErrors() {
        logger.warn("getErrors() called instead of getErrorsObservable(), blocking (likely a bug)");
        return (List)this.errorsObservable.toBlocking().first();
    }
}

