/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.Optional;
import org.dataloader.CacheKey;
import org.dataloader.CacheMap;
import org.dataloader.impl.Assertions;

public class DataLoaderOptions {
    private boolean batchingEnabled;
    private boolean cachingEnabled;
    private CacheKey cacheKeyFunction;
    private CacheMap cacheMap;
    private int maxBatchSize;

    public DataLoaderOptions() {
        this.batchingEnabled = true;
        this.cachingEnabled = true;
        this.maxBatchSize = -1;
    }

    public DataLoaderOptions(DataLoaderOptions other) {
        Assertions.nonNull(other);
        this.batchingEnabled = other.batchingEnabled;
        this.cachingEnabled = other.cachingEnabled;
        this.cacheKeyFunction = other.cacheKeyFunction;
        this.cacheMap = other.cacheMap;
        this.maxBatchSize = other.maxBatchSize;
    }

    public static DataLoaderOptions create() {
        return new DataLoaderOptions();
    }

    public boolean batchingEnabled() {
        return this.batchingEnabled;
    }

    public DataLoaderOptions setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
        return this;
    }

    public boolean cachingEnabled() {
        return this.cachingEnabled;
    }

    public DataLoaderOptions setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
        return this;
    }

    public Optional<CacheKey> cacheKeyFunction() {
        return Optional.ofNullable(this.cacheKeyFunction);
    }

    public DataLoaderOptions setCacheKeyFunction(CacheKey cacheKeyFunction) {
        this.cacheKeyFunction = cacheKeyFunction;
        return this;
    }

    public Optional<CacheMap> cacheMap() {
        return Optional.ofNullable(this.cacheMap);
    }

    public DataLoaderOptions setCacheMap(CacheMap cacheMap) {
        this.cacheMap = cacheMap;
        return this;
    }

    public int maxBatchSize() {
        return this.maxBatchSize;
    }

    public DataLoaderOptions setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
        return this;
    }
}

