/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.registries;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.annotations.ExperimentalApi;
import org.dataloader.impl.Assertions;
import org.dataloader.registries.DispatchPredicate;

@ExperimentalApi
public class ScheduledDataLoaderRegistry
extends DataLoaderRegistry
implements AutoCloseable {
    private final Map<DataLoader<?, ?>, DispatchPredicate> dataLoaderPredicates = new ConcurrentHashMap();
    private final DispatchPredicate dispatchPredicate;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Duration schedule;
    private final boolean tickerMode;
    private volatile boolean closed;

    private ScheduledDataLoaderRegistry(Builder builder) {
        this.dataLoaders.putAll(builder.dataLoaders);
        this.scheduledExecutorService = builder.scheduledExecutorService;
        this.schedule = builder.schedule;
        this.tickerMode = builder.tickerMode;
        this.closed = false;
        this.dispatchPredicate = builder.dispatchPredicate;
        this.dataLoaderPredicates.putAll(builder.dataLoaderPredicates);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public Duration getScheduleDuration() {
        return this.schedule;
    }

    public boolean isTickerMode() {
        return this.tickerMode;
    }

    @Override
    public ScheduledDataLoaderRegistry combine(DataLoaderRegistry registry) {
        Builder combinedBuilder = ScheduledDataLoaderRegistry.newScheduledRegistry().dispatchPredicate(this.dispatchPredicate);
        combinedBuilder.registerAll(this);
        combinedBuilder.registerAll(registry);
        return combinedBuilder.build();
    }

    @Override
    public ScheduledDataLoaderRegistry unregister(String key) {
        DataLoader dataLoader = (DataLoader)this.dataLoaders.remove(key);
        if (dataLoader != null) {
            this.dataLoaderPredicates.remove(dataLoader);
        }
        return this;
    }

    public Map<DataLoader<?, ?>, DispatchPredicate> getDataLoaderPredicates() {
        return new LinkedHashMap(this.dataLoaderPredicates);
    }

    public DispatchPredicate getDispatchPredicate() {
        return this.dispatchPredicate;
    }

    public ScheduledDataLoaderRegistry register(String key, DataLoader<?, ?> dataLoader, DispatchPredicate dispatchPredicate) {
        this.dataLoaders.put(key, dataLoader);
        this.dataLoaderPredicates.put(dataLoader, dispatchPredicate);
        return this;
    }

    @Override
    public void dispatchAll() {
        this.dispatchAllWithCount();
    }

    @Override
    public int dispatchAllWithCount() {
        int sum = 0;
        for (Map.Entry entry : this.dataLoaders.entrySet()) {
            DataLoader dataLoader = (DataLoader)entry.getValue();
            String key = (String)entry.getKey();
            sum += this.dispatchOrReschedule(key, dataLoader);
        }
        return sum;
    }

    public void dispatchAllImmediately() {
        this.dispatchAllWithCountImmediately();
    }

    public int dispatchAllWithCountImmediately() {
        return this.dataLoaders.values().stream().mapToInt(dataLoader -> dataLoader.dispatchWithCounts().getKeysCount()).sum();
    }

    public void rescheduleNow() {
        this.dataLoaders.forEach(this::reschedule);
    }

    private boolean shouldDispatch(String dataLoaderKey, DataLoader<?, ?> dataLoader) {
        DispatchPredicate dispatchPredicate = this.dataLoaderPredicates.get(dataLoader);
        if (dispatchPredicate != null && dispatchPredicate.test(dataLoaderKey, dataLoader)) {
            return true;
        }
        return this.dispatchPredicate.test(dataLoaderKey, dataLoader);
    }

    private void reschedule(String key, DataLoader<?, ?> dataLoader) {
        if (!this.closed) {
            Runnable runThis = () -> this.dispatchOrReschedule(key, dataLoader);
            this.scheduledExecutorService.schedule(runThis, this.schedule.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private int dispatchOrReschedule(String key, DataLoader<?, ?> dataLoader) {
        int sum = 0;
        boolean shouldDispatch = this.shouldDispatch(key, dataLoader);
        if (shouldDispatch) {
            sum = dataLoader.dispatchWithCounts().getKeysCount();
        }
        if (this.tickerMode || !shouldDispatch) {
            this.reschedule(key, dataLoader);
        }
        return sum;
    }

    public static Builder newScheduledRegistry() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, DataLoader<?, ?>> dataLoaders = new LinkedHashMap();
        private final Map<DataLoader<?, ?>, DispatchPredicate> dataLoaderPredicates = new LinkedHashMap();
        private DispatchPredicate dispatchPredicate = DispatchPredicate.DISPATCH_ALWAYS;
        private ScheduledExecutorService scheduledExecutorService;
        private Duration schedule = Duration.ofMillis(10L);
        private boolean tickerMode = false;

        public Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.scheduledExecutorService = Assertions.nonNull(executorService);
            return this;
        }

        public Builder schedule(Duration schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder register(String key, DataLoader<?, ?> dataLoader) {
            this.dataLoaders.put(key, dataLoader);
            return this;
        }

        public Builder register(String key, DataLoader<?, ?> dataLoader, DispatchPredicate dispatchPredicate) {
            this.register(key, dataLoader);
            this.dataLoaderPredicates.put(dataLoader, dispatchPredicate);
            return this;
        }

        public Builder registerAll(DataLoaderRegistry otherRegistry) {
            this.dataLoaders.putAll(otherRegistry.getDataLoadersMap());
            if (otherRegistry instanceof ScheduledDataLoaderRegistry) {
                ScheduledDataLoaderRegistry other = (ScheduledDataLoaderRegistry)otherRegistry;
                this.dataLoaderPredicates.putAll(other.dataLoaderPredicates);
            }
            return this;
        }

        public Builder dispatchPredicate(DispatchPredicate dispatchPredicate) {
            this.dispatchPredicate = dispatchPredicate;
            return this;
        }

        public Builder tickerMode(boolean tickerMode) {
            this.tickerMode = tickerMode;
            return this;
        }

        public ScheduledDataLoaderRegistry build() {
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            }
            return new ScheduledDataLoaderRegistry(this);
        }
    }
}

