/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.client.pkg.api.methods;

import com.greenapi.client.pkg.models.request.InstanceSettingsReq;
import com.greenapi.client.pkg.models.response.GetAuthorizationCodeResp;
import com.greenapi.client.pkg.models.response.LogoutResp;
import com.greenapi.client.pkg.models.response.Qr;
import com.greenapi.client.pkg.models.response.RebootResp;
import com.greenapi.client.pkg.models.response.SetProfilePictureResp;
import com.greenapi.client.pkg.models.response.SetSettingsResp;
import com.greenapi.client.pkg.models.response.Settings;
import com.greenapi.client.pkg.models.response.StateInstanceResp;
import com.greenapi.client.pkg.models.response.StatusInstanceResp;
import com.greenapi.client.pkg.models.response.WaSettings;
import java.io.File;
import java.util.HashMap;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class GreenApiAccount {
    private String host;
    private String instanceId;
    private String instanceToken;
    private RestTemplate restTemplate;

    public ResponseEntity<Settings> getSettings() {
        String url = this.host + "/waInstance" + this.instanceId + "/getSettings/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, Settings.class, new Object[0]);
    }

    public ResponseEntity<WaSettings> getWaSettings() {
        String url = this.host + "/waInstance" + this.instanceId + "/getWaSettings/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, WaSettings.class, new Object[0]);
    }

    public ResponseEntity<SetSettingsResp> setSetting(InstanceSettingsReq instanceSettings) {
        String url = this.host + "/waInstance" + this.instanceId + "/setSettings/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)instanceSettings, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SetSettingsResp.class, new Object[0]);
    }

    public ResponseEntity<StateInstanceResp> getStateInstance() {
        String url = this.host + "/waInstance" + this.instanceId + "/getStateInstance/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, StateInstanceResp.class, new Object[0]);
    }

    public ResponseEntity<StatusInstanceResp> getStatusInstance() {
        String url = this.host + "/waInstance" + this.instanceId + "/getStatusInstance/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, StatusInstanceResp.class, new Object[0]);
    }

    public ResponseEntity<RebootResp> reboot() {
        String url = this.host + "/waInstance" + this.instanceId + "/reboot/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, RebootResp.class, new Object[0]);
    }

    public ResponseEntity<LogoutResp> logout() {
        String url = this.host + "/waInstance" + this.instanceId + "/logout/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, LogoutResp.class, new Object[0]);
    }

    public ResponseEntity<Qr> getQrCode() {
        String url = this.host + "/waInstance" + this.instanceId + "/qr/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, Qr.class, new Object[0]);
    }

    public ResponseEntity<SetProfilePictureResp> setProfilePicture(File file) {
        String url = this.host + "/waInstance" + this.instanceId + "/setProfilePicture/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"file", (Object)new FileSystemResource(file));
        HttpEntity requestEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SetProfilePictureResp.class, new Object[0]);
    }

    public ResponseEntity<GetAuthorizationCodeResp> getAuthorizationCode(Long phoneNumber) {
        String url = this.host + "/waInstance" + this.instanceId + "/GetAuthorizationCode/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> body = new HashMap<String, Long>();
        body.put("phoneNumber", phoneNumber);
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, GetAuthorizationCodeResp.class, new Object[0]);
    }

    public GreenApiAccount(String host, String instanceId, String instanceToken, RestTemplate restTemplate) {
        this.host = host;
        this.instanceId = instanceId;
        this.instanceToken = instanceToken;
        this.restTemplate = restTemplate;
    }
}

