/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.client.pkg.api.methods;

import com.greenapi.client.pkg.models.request.ChangeGroupNameReq;
import com.greenapi.client.pkg.models.request.ChangeGroupPictureReq;
import com.greenapi.client.pkg.models.request.ChangeParticipantReq;
import com.greenapi.client.pkg.models.request.CreateGroupReq;
import com.greenapi.client.pkg.models.response.AddGroupParticipantResp;
import com.greenapi.client.pkg.models.response.ChangeGroupNameResp;
import com.greenapi.client.pkg.models.response.CreateGroupResp;
import com.greenapi.client.pkg.models.response.GroupData;
import com.greenapi.client.pkg.models.response.LeaveGroupResp;
import com.greenapi.client.pkg.models.response.RemoveGroupAdminResp;
import com.greenapi.client.pkg.models.response.RemoveGroupParticipantResp;
import com.greenapi.client.pkg.models.response.SetGroupAdminResp;
import com.greenapi.client.pkg.models.response.SetGroupPictureResp;
import java.util.HashMap;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class GreenApiGroups {
    private String host;
    private String instanceId;
    private String instanceToken;
    private RestTemplate restTemplate;

    public ResponseEntity<CreateGroupResp> createGroup(CreateGroupReq createGroupReq) {
        String url = this.host + "/waInstance" + this.instanceId + "/createGroup/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)createGroupReq, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, CreateGroupResp.class, new Object[0]);
    }

    public ResponseEntity<ChangeGroupNameResp> updateGroupName(ChangeGroupNameReq dto) {
        String url = this.host + "/waInstance" + this.instanceId + "/updateGroupName/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, ChangeGroupNameResp.class, new Object[0]);
    }

    public ResponseEntity<GroupData> getGroupData(String groupId) {
        String url = this.host + "/waInstance" + this.instanceId + "/getGroupData/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("groupId", groupId);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, GroupData.class, new Object[0]);
    }

    public ResponseEntity<AddGroupParticipantResp> addGroupParticipant(ChangeParticipantReq dto) {
        String url = this.host + "/waInstance" + this.instanceId + "/addGroupParticipant/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, AddGroupParticipantResp.class, new Object[0]);
    }

    public ResponseEntity<RemoveGroupParticipantResp> removeGroupParticipant(ChangeParticipantReq dto) {
        String url = this.host + "/waInstance" + this.instanceId + "/removeGroupParticipant/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, RemoveGroupParticipantResp.class, new Object[0]);
    }

    public ResponseEntity<SetGroupAdminResp> setGroupAdmin(ChangeParticipantReq dto) {
        String url = this.host + "/waInstance" + this.instanceId + "/setGroupAdmin/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SetGroupAdminResp.class, new Object[0]);
    }

    public ResponseEntity<RemoveGroupAdminResp> removeGroupAdmin(ChangeParticipantReq dto) {
        String url = this.host + "/waInstance" + this.instanceId + "/removeAdmin/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, RemoveGroupAdminResp.class, new Object[0]);
    }

    public ResponseEntity<SetGroupPictureResp> setGroupPicture(ChangeGroupPictureReq dto) {
        String url = this.host + "/waInstance" + this.instanceId + "/setGroupPicture/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"file", (Object)new FileSystemResource(dto.getFile()));
        form.add((Object)"groupId", (Object)dto.getGroupId());
        HttpEntity requestEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SetGroupPictureResp.class, new Object[0]);
    }

    public ResponseEntity<LeaveGroupResp> leaveGroup(String groupId) {
        String url = this.host + "/waInstance" + this.instanceId + "/leaveGroup/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("groupId", groupId);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, LeaveGroupResp.class, new Object[0]);
    }

    public GreenApiGroups(String host, String instanceId, String instanceToken, RestTemplate restTemplate) {
        this.host = host;
        this.instanceId = instanceId;
        this.instanceToken = instanceToken;
        this.restTemplate = restTemplate;
    }
}

