/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.client.pkg.api.methods;

import com.greenapi.client.pkg.models.ChatHistoryMessage;
import com.greenapi.client.pkg.models.request.GetChatHistoryReq;
import com.greenapi.client.pkg.models.request.MessageReq;
import com.greenapi.client.pkg.models.response.ChatMessage;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class GreenApiJournals {
    private String host;
    private String instanceId;
    private String instanceToken;
    private RestTemplate restTemplate;

    public ResponseEntity<List<ChatHistoryMessage>> getChatHistory(GetChatHistoryReq getChatHistoryReq) {
        String url = this.host + "/waInstance" + this.instanceId + "/getChatHistory/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)getChatHistoryReq, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ChatHistoryMessage>>(){}, new Object[0]);
    }

    public ResponseEntity<ChatMessage> getMessage(MessageReq messageReq) {
        String url = this.host + "/waInstance" + this.instanceId + "/getMessage/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)messageReq, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, ChatMessage.class, new Object[0]);
    }

    public ResponseEntity<List<ChatMessage>> lastIncomingMessages(Integer minutes) {
        String url = this.host + "/waInstance" + this.instanceId + "/lastIncomingMessages/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)minutes, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ChatMessage>>(){}, new Object[0]);
    }

    public ResponseEntity<List<ChatMessage>> lastOutgoingMessages(Integer minutes) {
        String url = this.host + "/waInstance" + this.instanceId + "/lastOutgoingMessages/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)minutes, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ChatMessage>>(){}, new Object[0]);
    }

    public GreenApiJournals(String host, String instanceId, String instanceToken, RestTemplate restTemplate) {
        this.host = host;
        this.instanceId = instanceId;
        this.instanceToken = instanceToken;
        this.restTemplate = restTemplate;
    }
}

