/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.client.pkg.api.methods;

import com.greenapi.client.pkg.models.request.MessageReq;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class GreenApiReceiving {
    private String host;
    private String instanceId;
    private String instanceToken;
    private RestTemplate restTemplate;

    public ResponseEntity<String> receiveNotification() {
        String url = this.host + "/waInstance" + this.instanceId + "/receiveNotification/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, String.class, new Object[0]);
    }

    public ResponseEntity<String> deleteNotification(Integer receiptId) {
        String url = this.host + "/waInstance" + this.instanceId + "/deleteNotification/" + this.instanceToken + "/" + receiptId;
        return this.restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, new Object[0]);
    }

    public ResponseEntity<byte[]> downloadFile(MessageReq messageReq) {
        String url = this.host + "/waInstance" + this.instanceId + "/downloadFile/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)messageReq, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, byte[].class, new Object[0]);
    }

    public GreenApiReceiving(String host, String instanceId, String instanceToken, RestTemplate restTemplate) {
        this.host = host;
        this.instanceId = instanceId;
        this.instanceToken = instanceToken;
        this.restTemplate = restTemplate;
    }
}

