/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.client.pkg.api.methods;

import com.greenapi.client.pkg.models.request.OutgoingButtons;
import com.greenapi.client.pkg.models.request.OutgoingContact;
import com.greenapi.client.pkg.models.request.OutgoingFileByUpload;
import com.greenapi.client.pkg.models.request.OutgoingFileByUrl;
import com.greenapi.client.pkg.models.request.OutgoingListMessage;
import com.greenapi.client.pkg.models.request.OutgoingLocation;
import com.greenapi.client.pkg.models.request.OutgoingMessage;
import com.greenapi.client.pkg.models.request.OutgoingPoll;
import com.greenapi.client.pkg.models.request.OutgoingTemplateButtons;
import com.greenapi.client.pkg.models.response.SendFileByUploadResp;
import com.greenapi.client.pkg.models.response.SendMessageResp;
import com.greenapi.client.pkg.models.response.UploadFileResp;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class GreenApiSending {
    private static final Logger log = LogManager.getLogger(GreenApiSending.class);
    private String host;
    private String hostMedia;
    private String instanceId;
    private String instanceToken;
    private RestTemplate restTemplate;

    public ResponseEntity<SendMessageResp> sendMessage(OutgoingMessage message) {
        String url = this.host + "/waInstance" + this.instanceId + "/sendMessage/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)message, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendMessageResp.class, new Object[0]);
    }

    public ResponseEntity<SendMessageResp> sendButtons(OutgoingButtons buttons) {
        String url = this.host + "/waInstance" + this.instanceId + "/sendButtons/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)buttons, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendMessageResp.class, new Object[0]);
    }

    public ResponseEntity<SendMessageResp> sendTemplateButtons(OutgoingTemplateButtons buttons) {
        String url = this.host + "/waInstance" + this.instanceId + "/sendTemplateButtons/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)buttons, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendMessageResp.class, new Object[0]);
    }

    public ResponseEntity<SendMessageResp> sendListMessage(OutgoingListMessage dto) {
        String url = this.host + "/waInstance" + this.instanceId + "/sendListMessage/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendMessageResp.class, new Object[0]);
    }

    public ResponseEntity<SendMessageResp> sendContact(OutgoingContact contact) {
        String url = this.host + "/waInstance" + this.instanceId + "/sendContact/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)contact, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendMessageResp.class, new Object[0]);
    }

    public ResponseEntity<SendFileByUploadResp> sendFileByUpload(OutgoingFileByUpload dto) {
        String url = this.hostMedia + "/waInstance" + this.instanceId + "/sendFileByUpload/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"chatId", (Object)dto.getChatId());
        form.add((Object)"file", (Object)new FileSystemResource(dto.getFile()));
        form.add((Object)"fileName", (Object)dto.getFileName());
        form.add((Object)"caption", (Object)dto.getCaption());
        form.add((Object)"quotedMessageId", (Object)dto.getQuotedMessageId());
        HttpEntity requestEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendFileByUploadResp.class, new Object[0]);
    }

    public ResponseEntity<SendMessageResp> sendFileByUrl(OutgoingFileByUrl fileByUrl) {
        String url = this.host + "/waInstance" + this.instanceId + "/sendFileByUrl/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)fileByUrl, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendMessageResp.class, new Object[0]);
    }

    public ResponseEntity<UploadFileResp> uploadFile(File file) throws IOException {
        String url = this.hostMedia + "/waInstance" + this.instanceId + "/uploadFile/" + this.instanceToken;
        ByteArrayResource byteArrayResource = new ByteArrayResource(Files.readAllBytes(file.toPath()));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaTypeFactory.getMediaType((String)file.getName()).orElse(MediaType.APPLICATION_OCTET_STREAM));
        HttpEntity requestEntity = new HttpEntity((Object)byteArrayResource, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, UploadFileResp.class, new Object[0]);
    }

    public ResponseEntity<SendMessageResp> sendLocation(OutgoingLocation location) {
        String url = this.host + "/waInstance" + this.instanceId + "/sendLocation/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)location, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendMessageResp.class, new Object[0]);
    }

    public ResponseEntity<SendMessageResp> sendPoll(OutgoingPoll poll) {
        String url = this.host + "/waInstance" + this.instanceId + "/sendPoll/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)poll, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SendMessageResp.class, new Object[0]);
    }

    public GreenApiSending(String host, String hostMedia, String instanceId, String instanceToken, RestTemplate restTemplate) {
        this.host = host;
        this.hostMedia = hostMedia;
        this.instanceId = instanceId;
        this.instanceToken = instanceToken;
        this.restTemplate = restTemplate;
    }
}

