/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.client.pkg.api.methods;

import com.greenapi.client.pkg.models.request.DeleteMessageReq;
import com.greenapi.client.pkg.models.request.EditMessageReq;
import com.greenapi.client.pkg.models.request.MessageReq;
import com.greenapi.client.pkg.models.response.CheckWhatsAppResp;
import com.greenapi.client.pkg.models.response.GetAvatarResp;
import com.greenapi.client.pkg.models.response.GetContactInfoResp;
import com.greenapi.client.pkg.models.response.GetContactsResp;
import com.greenapi.client.pkg.models.response.SetDisappearingChatResp;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class GreenApiService {
    private String host;
    private String instanceId;
    private String instanceToken;
    private RestTemplate restTemplate;

    public ResponseEntity<CheckWhatsAppResp> checkWhatsapp(Long phoneNumber) {
        String url = this.host + "/waInstance" + this.instanceId + "/checkWhatsapp/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> requestBody = new HashMap<String, Long>();
        requestBody.put("phoneNumber", phoneNumber);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, CheckWhatsAppResp.class, new Object[0]);
    }

    public ResponseEntity<GetAvatarResp> getAvatar(String chatId) {
        String url = this.host + "/waInstance" + this.instanceId + "/getAvatar/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("chatId", chatId);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, GetAvatarResp.class, new Object[0]);
    }

    public ResponseEntity<List<GetContactsResp>> getContacts() {
        String url = this.host + "/waInstance" + this.instanceId + "/getContacts/" + this.instanceToken;
        return this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<GetContactsResp>>(){}, new Object[0]);
    }

    public ResponseEntity<GetContactInfoResp> getContactInfo(String chatId) {
        String url = this.host + "/waInstance" + this.instanceId + "/getContactInfo/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("chatId", chatId);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, GetContactInfoResp.class, new Object[0]);
    }

    public ResponseEntity<String> deleteMessage(DeleteMessageReq deleteMessageReq) {
        String url = this.host + "/waInstance" + this.instanceId + "/deleteMessage/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)deleteMessageReq, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
    }

    public ResponseEntity<String> deleteMessage(MessageReq messageReq) {
        return this.deleteMessage(DeleteMessageReq.from(messageReq));
    }

    public ResponseEntity<String> editMessage(EditMessageReq messageReq) {
        String url = this.host + "/waInstance" + this.instanceId + "/editMessage/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)messageReq, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
    }

    public ResponseEntity<String> archiveChat(String chatId) {
        StringBuilder url = new StringBuilder();
        url.append(this.host).append("/waInstance").append(this.instanceId).append("/archiveChat/").append(this.instanceToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("chatId", chatId);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, String.class, new Object[0]);
    }

    public ResponseEntity<String> unarchiveChat(String chatId) {
        String url = this.host + "/waInstance" + this.instanceId + "/unarchiveChat/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("chatId", chatId);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
    }

    public ResponseEntity<SetDisappearingChatResp> setDisappearingChat(String chatId, Long ephemeralExpiration) {
        String url = this.host + "/waInstance" + this.instanceId + "/setDisappearingChat/" + this.instanceToken;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("chatId", chatId);
        requestBody.put("ephemeralExpiration", ephemeralExpiration);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, SetDisappearingChatResp.class, new Object[0]);
    }

    public GreenApiService(String host, String instanceId, String instanceToken, RestTemplate restTemplate) {
        this.host = host;
        this.instanceId = instanceId;
        this.instanceToken = instanceToken;
        this.restTemplate = restTemplate;
    }
}

