/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.client.pkg.api.webhook;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.greenapi.client.pkg.api.exceptions.GreenApiClientException;
import com.greenapi.client.pkg.api.webhook.QuotedMessageDeserializer;
import com.greenapi.client.pkg.models.notifications.ButtonsMessageWebhook;
import com.greenapi.client.pkg.models.notifications.ButtonsResponseMessageWebhook;
import com.greenapi.client.pkg.models.notifications.ContactMessageWebhook;
import com.greenapi.client.pkg.models.notifications.ContactsArrayMessageWebhook;
import com.greenapi.client.pkg.models.notifications.DeviceInfo;
import com.greenapi.client.pkg.models.notifications.ExtendedTextMessageWebhook;
import com.greenapi.client.pkg.models.notifications.FileMessageWebhook;
import com.greenapi.client.pkg.models.notifications.GroupInviteMessageWebhook;
import com.greenapi.client.pkg.models.notifications.IncomingBlock;
import com.greenapi.client.pkg.models.notifications.IncomingCall;
import com.greenapi.client.pkg.models.notifications.ListMessageWebhook;
import com.greenapi.client.pkg.models.notifications.ListResponseMessageWebhook;
import com.greenapi.client.pkg.models.notifications.LocationMessageWebhook;
import com.greenapi.client.pkg.models.notifications.Notification;
import com.greenapi.client.pkg.models.notifications.NotificationBody;
import com.greenapi.client.pkg.models.notifications.OutgoingMessageStatus;
import com.greenapi.client.pkg.models.notifications.PollMessageWebhook;
import com.greenapi.client.pkg.models.notifications.PollUpdateMessageWebhook;
import com.greenapi.client.pkg.models.notifications.QuotedMessageWebhook;
import com.greenapi.client.pkg.models.notifications.ReactionMessageWebhook;
import com.greenapi.client.pkg.models.notifications.StateInstanceChanged;
import com.greenapi.client.pkg.models.notifications.StatusInstanceChanged;
import com.greenapi.client.pkg.models.notifications.StickerMessageWebhook;
import com.greenapi.client.pkg.models.notifications.TemplateButtonsReplyMessageWebhook;
import com.greenapi.client.pkg.models.notifications.TemplateMessageWebhook;
import com.greenapi.client.pkg.models.notifications.TextMessageWebhook;
import com.greenapi.client.pkg.models.notifications.messages.quotedMessageData.QuotedMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class NotificationMapper {
    private static final Logger log = LogManager.getLogger(NotificationMapper.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public NotificationMapper() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(QuotedMessage.class, (JsonDeserializer)new QuotedMessageDeserializer());
        this.objectMapper.registerModule((Module)module);
    }

    public Notification get(String responseBody) {
        int receiptId = -1;
        try {
            JsonNode notification = this.objectMapper.readTree(responseBody);
            if (notification.has("body") && notification.has("receiptId")) {
                receiptId = notification.get("receiptId").asInt();
                return this.webhookTypeHandle(notification.get("body"), receiptId);
            }
            if (notification.has("typeWebhook")) {
                return this.webhookTypeHandle(notification, null);
            }
        }
        catch (JsonProcessingException e) {
            new GreenApiClientException("Webhook unknown type, please write to green-api support " + responseBody, e).printStackTrace();
        }
        return new Notification(receiptId, null);
    }

    private Notification webhookTypeHandle(JsonNode notificationBody, Integer receiptId) throws JsonProcessingException {
        switch (notificationBody.get("typeWebhook").asText()) {
            case "incomingMessageReceived": 
            case "outgoingMessageReceived": 
            case "outgoingAPIMessageReceived": {
                return this.messageTypeHandle(notificationBody, receiptId);
            }
            case "outgoingMessageStatus": {
                return new Notification(receiptId, (NotificationBody)this.objectMapper.readValue(notificationBody.toString(), OutgoingMessageStatus.class));
            }
            case "stateInstanceChanged": {
                return new Notification(receiptId, (NotificationBody)this.objectMapper.readValue(notificationBody.toString(), StatusInstanceChanged.class));
            }
            case "statusInstanceChanged": {
                return new Notification(receiptId, (NotificationBody)this.objectMapper.readValue(notificationBody.toString(), StateInstanceChanged.class));
            }
            case "deviceInfo": {
                return new Notification(receiptId, (NotificationBody)this.objectMapper.readValue(notificationBody.toString(), DeviceInfo.class));
            }
            case "incomingCall": {
                return new Notification(receiptId, (NotificationBody)this.objectMapper.readValue(notificationBody.toString(), IncomingCall.class));
            }
            case "incomingBlock": {
                return new Notification(receiptId, (NotificationBody)this.objectMapper.readValue(notificationBody.toString(), IncomingBlock.class));
            }
        }
        throw new GreenApiClientException("Unknown notification type " + String.valueOf(notificationBody));
    }

    private Notification messageTypeHandle(JsonNode notificationBody, Integer receiptId) throws JsonProcessingException {
        String typeMessage = notificationBody.get("messageData").get("typeMessage").asText();
        return new Notification(receiptId, (NotificationBody)this.objectMapper.readValue(notificationBody.toString(), this.getNotificationClass(typeMessage)));
    }

    private Class<?> getNotificationClass(String typeMessage) {
        switch (typeMessage) {
            case "quotedMessage": {
                return QuotedMessageWebhook.class;
            }
            case "textMessage": {
                return TextMessageWebhook.class;
            }
            case "extendedTextMessage": {
                return ExtendedTextMessageWebhook.class;
            }
            case "imageMessage": 
            case "videoMessage": 
            case "documentMessage": 
            case "audioMessage": {
                return FileMessageWebhook.class;
            }
            case "locationMessage": {
                return LocationMessageWebhook.class;
            }
            case "contactMessage": {
                return ContactMessageWebhook.class;
            }
            case "contactsArrayMessage": {
                return ContactsArrayMessageWebhook.class;
            }
            case "buttonsMessage": {
                return ButtonsMessageWebhook.class;
            }
            case "buttonsResponseMessage": {
                return ButtonsResponseMessageWebhook.class;
            }
            case "templateButtonsReplyMessage": {
                return TemplateButtonsReplyMessageWebhook.class;
            }
            case "listResponseMessage": {
                return ListResponseMessageWebhook.class;
            }
            case "listMessage": {
                return ListMessageWebhook.class;
            }
            case "templateMessage": {
                return TemplateMessageWebhook.class;
            }
            case "stickerMessage": {
                return StickerMessageWebhook.class;
            }
            case "reactionMessage": {
                return ReactionMessageWebhook.class;
            }
            case "groupInviteMessage": {
                return GroupInviteMessageWebhook.class;
            }
            case "pollMessage": {
                return PollMessageWebhook.class;
            }
            case "pollUpdateMessage": {
                return PollUpdateMessageWebhook.class;
            }
        }
        throw new GreenApiClientException("Message data unknown type " + typeMessage);
    }
}

