/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.client.pkg.api.webhook;

import com.greenapi.client.pkg.api.GreenApi;
import com.greenapi.client.pkg.api.webhook.NotificationMapper;
import com.greenapi.client.pkg.api.webhook.WebhookHandler;
import com.greenapi.client.pkg.models.notifications.Notification;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class WebhookConsumer {
    private static final Logger log = LogManager.getLogger(WebhookConsumer.class);
    private final GreenApi greenApi;
    private final NotificationMapper notificationMapper;
    private boolean running = true;

    public void start(WebhookHandler webhookHandler) {
        this.running = true;
        while (this.running) {
            try {
                ResponseEntity<String> response = this.greenApi.receiving.receiveNotification();
                if (Objects.equals(response.getBody(), "null")) {
                    log.info("receiveNotification timeout");
                    continue;
                }
                Notification notification = this.notificationMapper.get((String)response.getBody());
                if (notification.getBody() == null) {
                    log.error("Can't map webhook from json!");
                    this.greenApi.receiving.deleteNotification(notification.getReceiptId());
                    continue;
                }
                webhookHandler.handle(notification);
                this.greenApi.receiving.deleteNotification(notification.getReceiptId());
            }
            catch (Exception e) {
                log.error("UnexpectedError: " + String.valueOf(e));
                Thread.sleep(5000L);
            }
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
        } else {
            log.warn("webhookConsumer already stopped");
        }
    }

    public WebhookConsumer(GreenApi greenApi, NotificationMapper notificationMapper) {
        this.greenApi = greenApi;
        this.notificationMapper = notificationMapper;
    }
}

