/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.api;

import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.model.BillingAddressInfo;
import com.groupdocs.sdk.model.GetBillingAddressResponse;
import com.groupdocs.sdk.model.GetCountriesResponse;
import com.groupdocs.sdk.model.GetInvoicesResponse;
import com.groupdocs.sdk.model.GetPlanResponse;
import com.groupdocs.sdk.model.GetPurchaseWizardResponse;
import com.groupdocs.sdk.model.GetStatesResponse;
import com.groupdocs.sdk.model.GetSubscriptionPlanUsageResponse;
import com.groupdocs.sdk.model.GetSubscriptionPlansResponse;
import com.groupdocs.sdk.model.GetUserSubscriptionPlanResponse;
import com.groupdocs.sdk.model.SetUserSubscriptionPlanResponse;
import com.groupdocs.sdk.model.SubscriptionPlanInfo;
import com.groupdocs.sdk.model.UpdateSubscriptionPlanInfo;
import java.util.HashMap;

public class SystemApi {
    String basePath = "https://api.groupdocs.com/v2.0";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public GetInvoicesResponse SimulateAssessForPricingPlan(String userId, String discountCode, String planId) throws ApiException {
        if (userId == null || discountCode == null || planId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{userId}/plans/{planId}/discounts/{discountCode}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{discountCode}", String.valueOf(discountCode)).replace("{planId}", String.valueOf(planId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetInvoicesResponse)ApiInvoker.deserialize(response, "", GetInvoicesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetPlanResponse GetUserPlan(String callerId) throws ApiException {
        if (callerId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{callerId}/plan".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetPlanResponse)ApiInvoker.deserialize(response, "", GetPlanResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetUserSubscriptionPlanResponse GetUserSubscriptionPlan(String callerId) throws ApiException {
        if (callerId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{callerId}/subscription".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetUserSubscriptionPlanResponse)ApiInvoker.deserialize(response, "", GetUserSubscriptionPlanResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetSubscriptionPlansResponse GetSubscriptionPlans(String callerId, String family) throws ApiException {
        if (callerId == null || family == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{callerId}/plans/{family}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{family}", String.valueOf(family));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetSubscriptionPlansResponse)ApiInvoker.deserialize(response, "", GetSubscriptionPlansResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SetUserSubscriptionPlanResponse SetSubscriptionPlan(String userId, String productId, SubscriptionPlanInfo body) throws ApiException {
        if (userId == null || productId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{userId}/subscriptions/{productId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{productId}", String.valueOf(productId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SetUserSubscriptionPlanResponse)ApiInvoker.deserialize(response, "", SetUserSubscriptionPlanResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SetUserSubscriptionPlanResponse UpdateSubscriptionPlan(String userId, String productId, UpdateSubscriptionPlanInfo body) throws ApiException {
        if (userId == null || productId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{userId}/subscriptions/{productId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{productId}", String.valueOf(productId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (SetUserSubscriptionPlanResponse)ApiInvoker.deserialize(response, "", SetUserSubscriptionPlanResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetCountriesResponse GetCountries(String callerId) throws ApiException {
        if (callerId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{callerId}/countries".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetCountriesResponse)ApiInvoker.deserialize(response, "", GetCountriesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetStatesResponse GetStates(String callerId, String countryName) throws ApiException {
        if (callerId == null || countryName == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{callerId}/countries/{countryName}/states".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId)).replace("{countryName}", String.valueOf(countryName));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetStatesResponse)ApiInvoker.deserialize(response, "", GetStatesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetBillingAddressResponse SetBillingAddress(String userId, BillingAddressInfo body) throws ApiException {
        if (userId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{userId}/billingaddress".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (GetBillingAddressResponse)ApiInvoker.deserialize(response, "", GetBillingAddressResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetInvoicesResponse GetInvoices(String callerId, String pageNumber, Integer pageSize) throws ApiException {
        if (callerId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{callerId}/invoices?pageNumber={pageNumber}&pageSize={pageSize}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{callerId}", String.valueOf(callerId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(pageNumber))) {
            queryParams.put("pageNumber", String.valueOf(pageNumber));
        }
        if (!"null".equals(String.valueOf(pageSize))) {
            queryParams.put("pageSize", String.valueOf(pageSize));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetInvoicesResponse)ApiInvoker.deserialize(response, "", GetInvoicesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetSubscriptionPlanUsageResponse GetSubscriptionPlanUsage(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{userId}/usage".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetSubscriptionPlanUsageResponse)ApiInvoker.deserialize(response, "", GetSubscriptionPlanUsageResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetPurchaseWizardResponse GetPurchseWizardInfo(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/system/{userId}/purchase/wizard".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetPurchaseWizardResponse)ApiInvoker.deserialize(response, "", GetPurchaseWizardResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

